package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.{DomainNameString, Arn}
import scala.jdk.CollectionConverters.*
final case class ResendValidationEmailRequest(
    certificateArn: Arn,
    domain: DomainNameString,
    validationDomain: DomainNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest = {
    import ResendValidationEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .domain(DomainNameString.unwrap(domain): java.lang.String)
      .validationDomain(
        DomainNameString.unwrap(validationDomain): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ResendValidationEmailRequest.ReadOnly =
    zio.aws.acm.model.ResendValidationEmailRequest.wrap(buildAwsValue())
}
object ResendValidationEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ResendValidationEmailRequest =
      zio.aws.acm.model
        .ResendValidationEmailRequest(certificateArn, domain, validationDomain)
    def certificateArn: Arn
    def domain: DomainNameString
    def validationDomain: DomainNameString
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
    def getDomain: ZIO[Any, Nothing, DomainNameString] = ZIO.succeed(domain)
    def getValidationDomain: ZIO[Any, Nothing, DomainNameString] =
      ZIO.succeed(validationDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest
  ) extends zio.aws.acm.model.ResendValidationEmailRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
    override val domain: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.domain())
    override val validationDomain: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.validationDomain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest
  ): zio.aws.acm.model.ResendValidationEmailRequest.ReadOnly = new Wrapper(impl)
}
