package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: Option[TagValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.acm.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.Tag.ReadOnly =
    zio.aws.acm.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acm.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.Tag =
      zio.aws.acm.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Option[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.Tag
  ) extends zio.aws.acm.model.Tag.ReadOnly {
    override val key: TagKey = zio.aws.acm.model.primitives.TagKey(impl.key())
    override val value: Option[TagValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.acm.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.Tag
  ): zio.aws.acm.model.Tag.ReadOnly = new Wrapper(impl)
}
