package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class AddTagsToCertificateRequest(
    certificateArn: Arn,
    tags: Iterable[zio.aws.acm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest = {
    import AddTagsToCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.AddTagsToCertificateRequest.ReadOnly =
    zio.aws.acm.model.AddTagsToCertificateRequest.wrap(buildAwsValue())
}
object AddTagsToCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.AddTagsToCertificateRequest =
      zio.aws.acm.model.AddTagsToCertificateRequest(
        certificateArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def certificateArn: Arn
    def tags: List[zio.aws.acm.model.Tag.ReadOnly]
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.acm.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest
  ) extends zio.aws.acm.model.AddTagsToCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
    override val tags: List[zio.aws.acm.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.acm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest
  ): zio.aws.acm.model.AddTagsToCertificateRequest.ReadOnly = new Wrapper(impl)
}
