package zio.aws.acm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.acm.model.primitives.{TStamp, DomainNameString, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CertificateDetail(
    certificateArn: Optional[Arn] = Optional.Absent,
    domainName: Optional[DomainNameString] = Optional.Absent,
    subjectAlternativeNames: Optional[Iterable[DomainNameString]] =
      Optional.Absent,
    domainValidationOptions: Optional[
      Iterable[zio.aws.acm.model.DomainValidation]
    ] = Optional.Absent,
    serial: Optional[String] = Optional.Absent,
    subject: Optional[String] = Optional.Absent,
    issuer: Optional[String] = Optional.Absent,
    createdAt: Optional[TStamp] = Optional.Absent,
    issuedAt: Optional[TStamp] = Optional.Absent,
    importedAt: Optional[TStamp] = Optional.Absent,
    status: Optional[zio.aws.acm.model.CertificateStatus] = Optional.Absent,
    revokedAt: Optional[TStamp] = Optional.Absent,
    revocationReason: Optional[zio.aws.acm.model.RevocationReason] =
      Optional.Absent,
    notBefore: Optional[TStamp] = Optional.Absent,
    notAfter: Optional[TStamp] = Optional.Absent,
    keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm] = Optional.Absent,
    signatureAlgorithm: Optional[String] = Optional.Absent,
    inUseBy: Optional[Iterable[String]] = Optional.Absent,
    failureReason: Optional[zio.aws.acm.model.FailureReason] = Optional.Absent,
    `type`: Optional[zio.aws.acm.model.CertificateType] = Optional.Absent,
    renewalSummary: Optional[zio.aws.acm.model.RenewalSummary] =
      Optional.Absent,
    keyUsages: Optional[Iterable[zio.aws.acm.model.KeyUsage]] = Optional.Absent,
    extendedKeyUsages: Optional[Iterable[zio.aws.acm.model.ExtendedKeyUsage]] =
      Optional.Absent,
    certificateAuthorityArn: Optional[Arn] = Optional.Absent,
    renewalEligibility: Optional[zio.aws.acm.model.RenewalEligibility] =
      Optional.Absent,
    options: Optional[zio.aws.acm.model.CertificateOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.CertificateDetail = {
    import CertificateDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.CertificateDetail
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        domainName.map(value =>
          DomainNameString.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainNameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(serial.map(value => value: java.lang.String))(_.serial)
      .optionallyWith(subject.map(value => value: java.lang.String))(_.subject)
      .optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(issuedAt.map(value => TStamp.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(importedAt.map(value => TStamp.unwrap(value): Instant))(
        _.importedAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(revokedAt.map(value => TStamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(revocationReason.map(value => value.unwrap))(
        _.revocationReason
      )
      .optionallyWith(notBefore.map(value => TStamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => TStamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(keyAlgorithm.map(value => value.unwrap))(_.keyAlgorithm)
      .optionallyWith(signatureAlgorithm.map(value => value: java.lang.String))(
        _.signatureAlgorithm
      )
      .optionallyWith(
        inUseBy.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inUseBy)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(
        keyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyUsages)
      .optionallyWith(
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsages)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(renewalEligibility.map(value => value.unwrap))(
        _.renewalEligibility
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.CertificateDetail.ReadOnly =
    zio.aws.acm.model.CertificateDetail.wrap(buildAwsValue())
}
object CertificateDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.CertificateDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.CertificateDetail =
      zio.aws.acm.model.CertificateDetail(
        certificateArn.map(value => value),
        domainName.map(value => value),
        subjectAlternativeNames.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serial.map(value => value),
        subject.map(value => value),
        issuer.map(value => value),
        createdAt.map(value => value),
        issuedAt.map(value => value),
        importedAt.map(value => value),
        status.map(value => value),
        revokedAt.map(value => value),
        revocationReason.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        keyAlgorithm.map(value => value),
        signatureAlgorithm.map(value => value),
        inUseBy.map(value => value),
        failureReason.map(value => value),
        `type`.map(value => value),
        renewalSummary.map(value => value.asEditable),
        keyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        certificateAuthorityArn.map(value => value),
        renewalEligibility.map(value => value),
        options.map(value => value.asEditable)
      )
    def certificateArn: Optional[Arn]
    def domainName: Optional[DomainNameString]
    def subjectAlternativeNames: Optional[List[DomainNameString]]
    def domainValidationOptions
        : Optional[List[zio.aws.acm.model.DomainValidation.ReadOnly]]
    def serial: Optional[String]
    def subject: Optional[String]
    def issuer: Optional[String]
    def createdAt: Optional[TStamp]
    def issuedAt: Optional[TStamp]
    def importedAt: Optional[TStamp]
    def status: Optional[zio.aws.acm.model.CertificateStatus]
    def revokedAt: Optional[TStamp]
    def revocationReason: Optional[zio.aws.acm.model.RevocationReason]
    def notBefore: Optional[TStamp]
    def notAfter: Optional[TStamp]
    def keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm]
    def signatureAlgorithm: Optional[String]
    def inUseBy: Optional[List[String]]
    def failureReason: Optional[zio.aws.acm.model.FailureReason]
    def `type`: Optional[zio.aws.acm.model.CertificateType]
    def renewalSummary: Optional[zio.aws.acm.model.RenewalSummary.ReadOnly]
    def keyUsages: Optional[List[zio.aws.acm.model.KeyUsage.ReadOnly]]
    def extendedKeyUsages
        : Optional[List[zio.aws.acm.model.ExtendedKeyUsage.ReadOnly]]
    def certificateAuthorityArn: Optional[Arn]
    def renewalEligibility: Optional[zio.aws.acm.model.RenewalEligibility]
    def options: Optional[zio.aws.acm.model.CertificateOptions.ReadOnly]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDomainName: ZIO[Any, AwsError, DomainNameString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainNameString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.acm.model.DomainValidation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serial", serial)
    def getSubject: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subject", subject)
    def getIssuer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getIssuedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getImportedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("importedAt", importedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.acm.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRevokedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getRevocationReason
        : ZIO[Any, AwsError, zio.aws.acm.model.RevocationReason] =
      AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getNotBefore: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getKeyAlgorithm: ZIO[Any, AwsError, zio.aws.acm.model.KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getSignatureAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getInUseBy: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("inUseBy", inUseBy)
    def getFailureReason: ZIO[Any, AwsError, zio.aws.acm.model.FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getType: ZIO[Any, AwsError, zio.aws.acm.model.CertificateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRenewalSummary
        : ZIO[Any, AwsError, zio.aws.acm.model.RenewalSummary.ReadOnly] =
      AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getKeyUsages
        : ZIO[Any, AwsError, List[zio.aws.acm.model.KeyUsage.ReadOnly]] =
      AwsError.unwrapOptionField("keyUsages", keyUsages)
    def getExtendedKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.acm.model.ExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsages", extendedKeyUsages)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getRenewalEligibility
        : ZIO[Any, AwsError, zio.aws.acm.model.RenewalEligibility] =
      AwsError.unwrapOptionField("renewalEligibility", renewalEligibility)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.acm.model.CertificateOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.CertificateDetail
  ) extends zio.aws.acm.model.CertificateDetail.ReadOnly {
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val domainName: Optional[DomainNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.acm.model.primitives.DomainNameString(value))
    override val subjectAlternativeNames: Optional[List[DomainNameString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.primitives.DomainNameString(item)
          }.toList
        )
    override val domainValidationOptions
        : Optional[List[zio.aws.acm.model.DomainValidation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainValidationOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.DomainValidation.wrap(item)
          }.toList
        )
    override val serial: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serial())
      .map(value => value: String)
    override val subject: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => value: String)
    override val issuer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => value: String)
    override val createdAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val issuedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.issuedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val importedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.importedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val status: Optional[zio.aws.acm.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.acm.model.CertificateStatus.wrap(value))
    override val revokedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val revocationReason
        : Optional[zio.aws.acm.model.RevocationReason] = zio.aws.core.internal
      .optionalFromNullable(impl.revocationReason())
      .map(value => zio.aws.acm.model.RevocationReason.wrap(value))
    override val notBefore: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val notAfter: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyAlgorithm())
        .map(value => zio.aws.acm.model.KeyAlgorithm.wrap(value))
    override val signatureAlgorithm: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureAlgorithm())
      .map(value => value: String)
    override val inUseBy: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.inUseBy())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val failureReason: Optional[zio.aws.acm.model.FailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.acm.model.FailureReason.wrap(value))
    override val `type`: Optional[zio.aws.acm.model.CertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.acm.model.CertificateType.wrap(value))
    override val renewalSummary
        : Optional[zio.aws.acm.model.RenewalSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalSummary())
        .map(value => zio.aws.acm.model.RenewalSummary.wrap(value))
    override val keyUsages
        : Optional[List[zio.aws.acm.model.KeyUsage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.KeyUsage.wrap(item)
          }.toList
        )
    override val extendedKeyUsages
        : Optional[List[zio.aws.acm.model.ExtendedKeyUsage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedKeyUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.ExtendedKeyUsage.wrap(item)
          }.toList
        )
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val renewalEligibility
        : Optional[zio.aws.acm.model.RenewalEligibility] = zio.aws.core.internal
      .optionalFromNullable(impl.renewalEligibility())
      .map(value => zio.aws.acm.model.RenewalEligibility.wrap(value))
    override val options
        : Optional[zio.aws.acm.model.CertificateOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.acm.model.CertificateOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.CertificateDetail
  ): zio.aws.acm.model.CertificateDetail.ReadOnly = new Wrapper(impl)
}
