package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CertificateOptions(
    certificateTransparencyLoggingPreference: Optional[
      zio.aws.acm.model.CertificateTransparencyLoggingPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.CertificateOptions = {
    import CertificateOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.CertificateOptions
      .builder()
      .optionallyWith(
        certificateTransparencyLoggingPreference.map(value => value.unwrap)
      )(_.certificateTransparencyLoggingPreference)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.CertificateOptions.ReadOnly =
    zio.aws.acm.model.CertificateOptions.wrap(buildAwsValue())
}
object CertificateOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.CertificateOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.CertificateOptions =
      zio.aws.acm.model.CertificateOptions(
        certificateTransparencyLoggingPreference.map(value => value)
      )
    def certificateTransparencyLoggingPreference
        : Optional[zio.aws.acm.model.CertificateTransparencyLoggingPreference]
    def getCertificateTransparencyLoggingPreference: ZIO[
      Any,
      AwsError,
      zio.aws.acm.model.CertificateTransparencyLoggingPreference
    ] = AwsError.unwrapOptionField(
      "certificateTransparencyLoggingPreference",
      certificateTransparencyLoggingPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.CertificateOptions
  ) extends zio.aws.acm.model.CertificateOptions.ReadOnly {
    override val certificateTransparencyLoggingPreference
        : Optional[zio.aws.acm.model.CertificateTransparencyLoggingPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateTransparencyLoggingPreference())
        .map(value =>
          zio.aws.acm.model.CertificateTransparencyLoggingPreference.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.CertificateOptions
  ): zio.aws.acm.model.CertificateOptions.ReadOnly = new Wrapper(impl)
}
