package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.{PassphraseBlob, Arn}
import scala.jdk.CollectionConverters.*
final case class ExportCertificateRequest(
    certificateArn: Arn,
    passphrase: PassphraseBlob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExportCertificateRequest = {
    import ExportCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExportCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .passphrase(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(passphrase.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExportCertificateRequest.ReadOnly =
    zio.aws.acm.model.ExportCertificateRequest.wrap(buildAwsValue())
}
object ExportCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExportCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExportCertificateRequest =
      zio.aws.acm.model.ExportCertificateRequest(certificateArn, passphrase)
    def certificateArn: Arn
    def passphrase: PassphraseBlob
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
    def getPassphrase: ZIO[Any, Nothing, PassphraseBlob] =
      ZIO.succeed(passphrase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateRequest
  ) extends zio.aws.acm.model.ExportCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
    override val passphrase: PassphraseBlob =
      zio.aws.acm.model.primitives.PassphraseBlob(
        zio.Chunk.fromArray(impl.passphrase().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateRequest
  ): zio.aws.acm.model.ExportCertificateRequest.ReadOnly = new Wrapper(impl)
}
