package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{
  CertificateChainBlob,
  PrivateKeyBlob,
  CertificateBodyBlob,
  Arn
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportCertificateRequest(
    certificateArn: Optional[Arn] = Optional.Absent,
    certificate: CertificateBodyBlob,
    privateKey: PrivateKeyBlob,
    certificateChain: Optional[CertificateChainBlob] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.acm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ImportCertificateRequest = {
    import ImportCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ImportCertificateRequest
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .certificate(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(certificate.toArray[Byte])
      )
      .privateKey(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(privateKey.toArray[Byte])
      )
      .optionallyWith(
        certificateChain.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.certificateChain)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ImportCertificateRequest.ReadOnly =
    zio.aws.acm.model.ImportCertificateRequest.wrap(buildAwsValue())
}
object ImportCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ImportCertificateRequest =
      zio.aws.acm.model.ImportCertificateRequest(
        certificateArn.map(value => value),
        certificate,
        privateKey,
        certificateChain.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateArn: Optional[Arn]
    def certificate: CertificateBodyBlob
    def privateKey: PrivateKeyBlob
    def certificateChain: Optional[CertificateChainBlob]
    def tags: Optional[List[zio.aws.acm.model.Tag.ReadOnly]]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificate: ZIO[Any, Nothing, CertificateBodyBlob] =
      ZIO.succeed(certificate)
    def getPrivateKey: ZIO[Any, Nothing, PrivateKeyBlob] =
      ZIO.succeed(privateKey)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainBlob] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getTags: ZIO[Any, AwsError, List[zio.aws.acm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ) extends zio.aws.acm.model.ImportCertificateRequest.ReadOnly {
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val certificate: CertificateBodyBlob =
      zio.aws.acm.model.primitives.CertificateBodyBlob(
        zio.Chunk.fromArray(impl.certificate().asByteArrayUnsafe())
      )
    override val privateKey: PrivateKeyBlob =
      zio.aws.acm.model.primitives.PrivateKeyBlob(
        zio.Chunk.fromArray(impl.privateKey().asByteArrayUnsafe())
      )
    override val certificateChain: Optional[CertificateChainBlob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value =>
          zio.aws.acm.model.primitives.CertificateChainBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val tags: Optional[List[zio.aws.acm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ): zio.aws.acm.model.ImportCertificateRequest.ReadOnly = new Wrapper(impl)
}
