package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportCertificateResponse(
    certificateArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ImportCertificateResponse = {
    import ImportCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ImportCertificateResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ImportCertificateResponse.ReadOnly =
    zio.aws.acm.model.ImportCertificateResponse.wrap(buildAwsValue())
}
object ImportCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ImportCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ImportCertificateResponse =
      zio.aws.acm.model
        .ImportCertificateResponse(certificateArn.map(value => value))
    def certificateArn: Optional[Arn]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateResponse
  ) extends zio.aws.acm.model.ImportCertificateResponse.ReadOnly {
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateResponse
  ): zio.aws.acm.model.ImportCertificateResponse.ReadOnly = new Wrapper(impl)
}
