package zio.aws.acm.model
import scala.jdk.CollectionConverters.*
sealed trait KeyAlgorithm {
  def unwrap: software.amazon.awssdk.services.acm.model.KeyAlgorithm
}
object KeyAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.KeyAlgorithm
  ): zio.aws.acm.model.KeyAlgorithm = value match {
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_1024 =>
      val r = RSA_1024
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_2048 =>
      val r = RSA_2048
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_3072 =>
      val r = RSA_3072
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_4096 =>
      val r = RSA_4096
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_PRIME256_V1 =>
      val r = EC_prime256v1
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_SECP384_R1 =>
      val r = EC_secp384r1
      r
    case software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_SECP521_R1 =>
      val r = EC_secp521r1
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_1024 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_1024
  }
  case object RSA_2048 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_2048
  }
  case object RSA_3072 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_3072
  }
  case object RSA_4096 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.RSA_4096
  }
  case object EC_prime256v1 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_PRIME256_V1
  }
  case object EC_secp384r1 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_SECP384_R1
  }
  case object EC_secp521r1 extends zio.aws.acm.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyAlgorithm =
      software.amazon.awssdk.services.acm.model.KeyAlgorithm.EC_SECP521_R1
  }
}
