package zio.aws.acm.model
import scala.jdk.CollectionConverters.*
sealed trait RenewalStatus {
  def unwrap: software.amazon.awssdk.services.acm.model.RenewalStatus
}
object RenewalStatus {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.RenewalStatus
  ): zio.aws.acm.model.RenewalStatus = value match {
    case software.amazon.awssdk.services.acm.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.RenewalStatus.PENDING_AUTO_RENEWAL =>
      val r = PENDING_AUTO_RENEWAL
      r
    case software.amazon.awssdk.services.acm.model.RenewalStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.acm.model.RenewalStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.acm.model.RenewalStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalStatus =
      software.amazon.awssdk.services.acm.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_AUTO_RENEWAL extends zio.aws.acm.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalStatus =
      software.amazon.awssdk.services.acm.model.RenewalStatus.PENDING_AUTO_RENEWAL
  }
  case object PENDING_VALIDATION extends zio.aws.acm.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalStatus =
      software.amazon.awssdk.services.acm.model.RenewalStatus.PENDING_VALIDATION
  }
  case object SUCCESS extends zio.aws.acm.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalStatus =
      software.amazon.awssdk.services.acm.model.RenewalStatus.SUCCESS
  }
  case object FAILED extends zio.aws.acm.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalStatus =
      software.amazon.awssdk.services.acm.model.RenewalStatus.FAILED
  }
}
