package zio.aws.acm.model
import scala.jdk.CollectionConverters.*
sealed trait RevocationReason {
  def unwrap: software.amazon.awssdk.services.acm.model.RevocationReason
}
object RevocationReason {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.RevocationReason
  ): zio.aws.acm.model.RevocationReason = value match {
    case software.amazon.awssdk.services.acm.model.RevocationReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.UNSPECIFIED =>
      val r = UNSPECIFIED
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.KEY_COMPROMISE =>
      val r = KEY_COMPROMISE
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.CA_COMPROMISE =>
      val r = CA_COMPROMISE
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.AFFILIATION_CHANGED =>
      val r = AFFILIATION_CHANGED
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.SUPERCEDED =>
      val r = SUPERCEDED
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.CESSATION_OF_OPERATION =>
      val r = CESSATION_OF_OPERATION
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.CERTIFICATE_HOLD =>
      val r = CERTIFICATE_HOLD
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.REMOVE_FROM_CRL =>
      val r = REMOVE_FROM_CRL
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.PRIVILEGE_WITHDRAWN =>
      val r = PRIVILEGE_WITHDRAWN
      r
    case software.amazon.awssdk.services.acm.model.RevocationReason.A_A_COMPROMISE =>
      val r = A_A_COMPROMISE
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.UNKNOWN_TO_SDK_VERSION
  }
  case object UNSPECIFIED extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.UNSPECIFIED
  }
  case object KEY_COMPROMISE extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.KEY_COMPROMISE
  }
  case object CA_COMPROMISE extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.CA_COMPROMISE
  }
  case object AFFILIATION_CHANGED extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.AFFILIATION_CHANGED
  }
  case object SUPERCEDED extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.SUPERCEDED
  }
  case object CESSATION_OF_OPERATION
      extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.CESSATION_OF_OPERATION
  }
  case object CERTIFICATE_HOLD extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.CERTIFICATE_HOLD
  }
  case object REMOVE_FROM_CRL extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.REMOVE_FROM_CRL
  }
  case object PRIVILEGE_WITHDRAWN extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.PRIVILEGE_WITHDRAWN
  }
  case object A_A_COMPROMISE extends zio.aws.acm.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RevocationReason =
      software.amazon.awssdk.services.acm.model.RevocationReason.A_A_COMPROMISE
  }
}
