package zio.aws.acm.model
import scala.jdk.CollectionConverters.*
sealed trait SortBy {
  def unwrap: software.amazon.awssdk.services.acm.model.SortBy
}
object SortBy {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.SortBy
  ): zio.aws.acm.model.SortBy = value match {
    case software.amazon.awssdk.services.acm.model.SortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.SortBy.CREATED_AT =>
      val r = CREATED_AT
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.SortBy {
    override def unwrap: software.amazon.awssdk.services.acm.model.SortBy =
      software.amazon.awssdk.services.acm.model.SortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED_AT extends zio.aws.acm.model.SortBy {
    override def unwrap: software.amazon.awssdk.services.acm.model.SortBy =
      software.amazon.awssdk.services.acm.model.SortBy.CREATED_AT
  }
}
