package zio.aws.acmpca
import software.amazon.awssdk.services.acmpca.model.{
  RestoreCertificateAuthorityRequest,
  GetCertificateAuthorityCsrRequest,
  CertificateAuthority,
  CreateCertificateAuthorityAuditReportRequest,
  DeleteCertificateAuthorityRequest,
  RevokeCertificateResponse,
  ListTagsRequest,
  ListCertificateAuthoritiesRequest,
  RestoreCertificateAuthorityResponse,
  GetCertificateAuthorityCertificateResponse,
  DeletePermissionRequest,
  TagCertificateAuthorityRequest,
  CreateCertificateAuthorityResponse,
  PutPolicyResponse,
  GetCertificateResponse,
  Tag,
  DeletePermissionResponse,
  ListPermissionsResponse,
  IssueCertificateRequest,
  IssueCertificateResponse,
  DescribeCertificateAuthorityResponse,
  GetPolicyResponse,
  TagCertificateAuthorityResponse,
  DescribeCertificateAuthorityAuditReportResponse,
  Permission,
  DeletePolicyResponse,
  UpdateCertificateAuthorityRequest,
  ImportCertificateAuthorityCertificateResponse,
  GetPolicyRequest,
  ListPermissionsRequest,
  ImportCertificateAuthorityCertificateRequest,
  RevokeCertificateRequest,
  UntagCertificateAuthorityResponse,
  CreatePermissionResponse,
  CreateCertificateAuthorityAuditReportResponse,
  GetCertificateAuthorityCsrResponse,
  UntagCertificateAuthorityRequest,
  GetCertificateAuthorityCertificateRequest,
  DeleteCertificateAuthorityResponse,
  ListCertificateAuthoritiesResponse,
  DeletePolicyRequest,
  DescribeCertificateAuthorityAuditReportRequest,
  CreateCertificateAuthorityRequest,
  DescribeCertificateAuthorityRequest,
  PutPolicyRequest,
  UpdateCertificateAuthorityResponse,
  CreatePermissionRequest,
  ListTagsResponse,
  GetCertificateRequest
}
import zio.aws.acmpca.model.IssueCertificateResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.acmpca.{
  AcmPcaAsyncClientBuilder,
  AcmPcaAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AcmPca extends AspectSupport[AcmPca] {
  val api: AcmPcaAsyncClient
  def getCertificateAuthorityCertificate(
      request: zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.ReadOnly
  ]
  def revokeCertificate(
      request: zio.aws.acmpca.model.RevokeCertificateRequest
  ): IO[AwsError, Unit]
  def importCertificateAuthorityCertificate(
      request: zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest
  ): IO[AwsError, Unit]
  def getCertificateAuthorityCsr(
      request: zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly
  ]
  def issueCertificate(
      request: zio.aws.acmpca.model.IssueCertificateRequest
  ): IO[AwsError, ReadOnly]
  def listTags(
      request: zio.aws.acmpca.model.ListTagsRequest
  ): ZStream[Any, AwsError, zio.aws.acmpca.model.Tag.ReadOnly]
  def listTagsPaginated(
      request: zio.aws.acmpca.model.ListTagsRequest
  ): IO[AwsError, zio.aws.acmpca.model.ListTagsResponse.ReadOnly]
  def deletePermission(
      request: zio.aws.acmpca.model.DeletePermissionRequest
  ): IO[AwsError, Unit]
  def createCertificateAuthority(
      request: zio.aws.acmpca.model.CreateCertificateAuthorityRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly
  ]
  def describeCertificateAuthorityAuditReport(
      request: zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly
  ]
  def putPolicy(
      request: zio.aws.acmpca.model.PutPolicyRequest
  ): IO[AwsError, Unit]
  def restoreCertificateAuthority(
      request: zio.aws.acmpca.model.RestoreCertificateAuthorityRequest
  ): IO[AwsError, Unit]
  def describeCertificateAuthority(
      request: zio.aws.acmpca.model.DescribeCertificateAuthorityRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly
  ]
  def listPermissions(
      request: zio.aws.acmpca.model.ListPermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.acmpca.model.Permission.ReadOnly]
  def listPermissionsPaginated(
      request: zio.aws.acmpca.model.ListPermissionsRequest
  ): IO[AwsError, zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly]
  def deletePolicy(
      request: zio.aws.acmpca.model.DeletePolicyRequest
  ): IO[AwsError, Unit]
  def getPolicy(
      request: zio.aws.acmpca.model.GetPolicyRequest
  ): IO[AwsError, zio.aws.acmpca.model.GetPolicyResponse.ReadOnly]
  def updateCertificateAuthority(
      request: zio.aws.acmpca.model.UpdateCertificateAuthorityRequest
  ): IO[AwsError, Unit]
  def getCertificate(
      request: zio.aws.acmpca.model.GetCertificateRequest
  ): IO[AwsError, zio.aws.acmpca.model.GetCertificateResponse.ReadOnly]
  def listCertificateAuthorities(
      request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
  ): ZStream[Any, AwsError, zio.aws.acmpca.model.CertificateAuthority.ReadOnly]
  def listCertificateAuthoritiesPaginated(
      request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly
  ]
  def createPermission(
      request: zio.aws.acmpca.model.CreatePermissionRequest
  ): IO[AwsError, Unit]
  def createCertificateAuthorityAuditReport(
      request: zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest
  ): IO[
    AwsError,
    zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly
  ]
  def deleteCertificateAuthority(
      request: zio.aws.acmpca.model.DeleteCertificateAuthorityRequest
  ): IO[AwsError, Unit]
  def tagCertificateAuthority(
      request: zio.aws.acmpca.model.TagCertificateAuthorityRequest
  ): IO[AwsError, Unit]
  def untagCertificateAuthority(
      request: zio.aws.acmpca.model.UntagCertificateAuthorityRequest
  ): IO[AwsError, Unit]
}
object AcmPca {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AcmPca] = customized(
    identity
  )
  def customized(
      customization: AcmPcaAsyncClientBuilder => AcmPcaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AcmPca] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AcmPcaAsyncClientBuilder => AcmPcaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AcmPca] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AcmPcaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AcmPcaAsyncClient, AcmPcaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AcmPcaAsyncClient, AcmPcaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AcmPcaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AcmPcaImpl[R](
      override val api: AcmPcaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AcmPca
      with AwsServiceBase[R] {
    override val serviceName: String = "AcmPca"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AcmPcaImpl[R1] = new AcmPcaImpl(api, newAspect, r)
    def getCertificateAuthorityCertificate(
        request: zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCertificateAuthorityCertificateRequest,
      GetCertificateAuthorityCertificateResponse
    ](
      "getCertificateAuthorityCertificate",
      api.getCertificateAuthorityCertificate
    )(request.buildAwsValue())
      .map(zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.wrap)
      .provideEnvironment(r)
    def revokeCertificate(
        request: zio.aws.acmpca.model.RevokeCertificateRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[RevokeCertificateRequest, RevokeCertificateResponse](
        "revokeCertificate",
        api.revokeCertificate
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def importCertificateAuthorityCertificate(
        request: zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ImportCertificateAuthorityCertificateRequest,
      ImportCertificateAuthorityCertificateResponse
    ](
      "importCertificateAuthorityCertificate",
      api.importCertificateAuthorityCertificate
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getCertificateAuthorityCsr(
        request: zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCertificateAuthorityCsrRequest,
      GetCertificateAuthorityCsrResponse
    ]("getCertificateAuthorityCsr", api.getCertificateAuthorityCsr)(
      request.buildAwsValue()
    ).map(zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.wrap)
      .provideEnvironment(r)
    def issueCertificate(
        request: zio.aws.acmpca.model.IssueCertificateRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[IssueCertificateRequest, IssueCertificateResponse](
        "issueCertificate",
        api.issueCertificate
      )(request.buildAwsValue())
        .map(zio.aws.acmpca.model.IssueCertificateResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: zio.aws.acmpca.model.ListTagsRequest
    ): ZStream[Any, AwsError, zio.aws.acmpca.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[ListTagsRequest, ListTagsResponse, Tag](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.acmpca.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsPaginated(
        request: zio.aws.acmpca.model.ListTagsRequest
    ): IO[AwsError, zio.aws.acmpca.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[ListTagsRequest, ListTagsResponse](
        "listTags",
        api.listTags
      )(request.buildAwsValue())
        .map(zio.aws.acmpca.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def deletePermission(
        request: zio.aws.acmpca.model.DeletePermissionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePermissionRequest, DeletePermissionResponse](
        "deletePermission",
        api.deletePermission
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createCertificateAuthority(
        request: zio.aws.acmpca.model.CreateCertificateAuthorityRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCertificateAuthorityRequest,
      CreateCertificateAuthorityResponse
    ]("createCertificateAuthority", api.createCertificateAuthority)(
      request.buildAwsValue()
    ).map(zio.aws.acmpca.model.CreateCertificateAuthorityResponse.wrap)
      .provideEnvironment(r)
    def describeCertificateAuthorityAuditReport(
        request: zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCertificateAuthorityAuditReportRequest,
      DescribeCertificateAuthorityAuditReportResponse
    ](
      "describeCertificateAuthorityAuditReport",
      api.describeCertificateAuthorityAuditReport
    )(request.buildAwsValue())
      .map(
        zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.wrap
      )
      .provideEnvironment(r)
    def putPolicy(
        request: zio.aws.acmpca.model.PutPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutPolicyRequest, PutPolicyResponse](
        "putPolicy",
        api.putPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def restoreCertificateAuthority(
        request: zio.aws.acmpca.model.RestoreCertificateAuthorityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RestoreCertificateAuthorityRequest,
      RestoreCertificateAuthorityResponse
    ]("restoreCertificateAuthority", api.restoreCertificateAuthority)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeCertificateAuthority(
        request: zio.aws.acmpca.model.DescribeCertificateAuthorityRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCertificateAuthorityRequest,
      DescribeCertificateAuthorityResponse
    ]("describeCertificateAuthority", api.describeCertificateAuthority)(
      request.buildAwsValue()
    ).map(zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.wrap)
      .provideEnvironment(r)
    def listPermissions(
        request: zio.aws.acmpca.model.ListPermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.acmpca.model.Permission.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPermissionsRequest,
        ListPermissionsResponse,
        Permission
      ](
        "listPermissions",
        api.listPermissions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.permissions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.acmpca.model.Permission.wrap(item))
        .provideEnvironment(r)
    def listPermissionsPaginated(
        request: zio.aws.acmpca.model.ListPermissionsRequest
    ): IO[AwsError, zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly] =
      asyncRequestResponse[ListPermissionsRequest, ListPermissionsResponse](
        "listPermissions",
        api.listPermissions
      )(request.buildAwsValue())
        .map(zio.aws.acmpca.model.ListPermissionsResponse.wrap)
        .provideEnvironment(r)
    def deletePolicy(
        request: zio.aws.acmpca.model.DeletePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePolicyRequest, DeletePolicyResponse](
        "deletePolicy",
        api.deletePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getPolicy(
        request: zio.aws.acmpca.model.GetPolicyRequest
    ): IO[AwsError, zio.aws.acmpca.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetPolicyRequest, GetPolicyResponse](
        "getPolicy",
        api.getPolicy
      )(request.buildAwsValue())
        .map(zio.aws.acmpca.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateCertificateAuthority(
        request: zio.aws.acmpca.model.UpdateCertificateAuthorityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateCertificateAuthorityRequest,
      UpdateCertificateAuthorityResponse
    ]("updateCertificateAuthority", api.updateCertificateAuthority)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getCertificate(
        request: zio.aws.acmpca.model.GetCertificateRequest
    ): IO[AwsError, zio.aws.acmpca.model.GetCertificateResponse.ReadOnly] =
      asyncRequestResponse[GetCertificateRequest, GetCertificateResponse](
        "getCertificate",
        api.getCertificate
      )(request.buildAwsValue())
        .map(zio.aws.acmpca.model.GetCertificateResponse.wrap)
        .provideEnvironment(r)
    def listCertificateAuthorities(
        request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.acmpca.model.CertificateAuthority.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListCertificateAuthoritiesRequest,
      ListCertificateAuthoritiesResponse,
      CertificateAuthority
    ](
      "listCertificateAuthorities",
      api.listCertificateAuthorities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.certificateAuthorities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.acmpca.model.CertificateAuthority.wrap(item))
      .provideEnvironment(r)
    def listCertificateAuthoritiesPaginated(
        request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCertificateAuthoritiesRequest,
      ListCertificateAuthoritiesResponse
    ]("listCertificateAuthorities", api.listCertificateAuthorities)(
      request.buildAwsValue()
    ).map(zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.wrap)
      .provideEnvironment(r)
    def createPermission(
        request: zio.aws.acmpca.model.CreatePermissionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CreatePermissionRequest, CreatePermissionResponse](
        "createPermission",
        api.createPermission
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createCertificateAuthorityAuditReport(
        request: zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest
    ): IO[
      AwsError,
      zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCertificateAuthorityAuditReportRequest,
      CreateCertificateAuthorityAuditReportResponse
    ](
      "createCertificateAuthorityAuditReport",
      api.createCertificateAuthorityAuditReport
    )(request.buildAwsValue())
      .map(
        zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCertificateAuthority(
        request: zio.aws.acmpca.model.DeleteCertificateAuthorityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteCertificateAuthorityRequest,
      DeleteCertificateAuthorityResponse
    ]("deleteCertificateAuthority", api.deleteCertificateAuthority)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagCertificateAuthority(
        request: zio.aws.acmpca.model.TagCertificateAuthorityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      TagCertificateAuthorityRequest,
      TagCertificateAuthorityResponse
    ]("tagCertificateAuthority", api.tagCertificateAuthority)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def untagCertificateAuthority(
        request: zio.aws.acmpca.model.UntagCertificateAuthorityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UntagCertificateAuthorityRequest,
      UntagCertificateAuthorityResponse
    ]("untagCertificateAuthority", api.untagCertificateAuthority)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def getCertificateAuthorityCertificate(
      request: zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCertificateAuthorityCertificate(request))
  def revokeCertificate(
      request: zio.aws.acmpca.model.RevokeCertificateRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.revokeCertificate(request))
  def importCertificateAuthorityCertificate(
      request: zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.importCertificateAuthorityCertificate(request))
  def getCertificateAuthorityCsr(
      request: zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCertificateAuthorityCsr(request))
  def issueCertificate(
      request: zio.aws.acmpca.model.IssueCertificateRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.issueCertificate(request))
  def listTags(request: zio.aws.acmpca.model.ListTagsRequest): ZStream[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: zio.aws.acmpca.model.ListTagsRequest): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def deletePermission(
      request: zio.aws.acmpca.model.DeletePermissionRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePermission(request))
  def createCertificateAuthority(
      request: zio.aws.acmpca.model.CreateCertificateAuthorityRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCertificateAuthority(request))
  def describeCertificateAuthorityAuditReport(
      request: zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificateAuthorityAuditReport(request))
  def putPolicy(
      request: zio.aws.acmpca.model.PutPolicyRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putPolicy(request))
  def restoreCertificateAuthority(
      request: zio.aws.acmpca.model.RestoreCertificateAuthorityRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.restoreCertificateAuthority(request))
  def describeCertificateAuthority(
      request: zio.aws.acmpca.model.DescribeCertificateAuthorityRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificateAuthority(request))
  def listPermissions(
      request: zio.aws.acmpca.model.ListPermissionsRequest
  ): ZStream[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.Permission.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissions(request))
  def listPermissionsPaginated(
      request: zio.aws.acmpca.model.ListPermissionsRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionsPaginated(request))
  def deletePolicy(
      request: zio.aws.acmpca.model.DeletePolicyRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicy(request))
  def getPolicy(request: zio.aws.acmpca.model.GetPolicyRequest): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def updateCertificateAuthority(
      request: zio.aws.acmpca.model.UpdateCertificateAuthorityRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateCertificateAuthority(request))
  def getCertificate(request: zio.aws.acmpca.model.GetCertificateRequest): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.GetCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCertificate(request))
  def listCertificateAuthorities(
      request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
  ): ZStream[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.CertificateAuthority.ReadOnly
  ] = ZStream.serviceWithStream(_.listCertificateAuthorities(request))
  def listCertificateAuthoritiesPaginated(
      request: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCertificateAuthoritiesPaginated(request))
  def createPermission(
      request: zio.aws.acmpca.model.CreatePermissionRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createPermission(request))
  def createCertificateAuthorityAuditReport(
      request: zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest
  ): ZIO[
    zio.aws.acmpca.AcmPca,
    AwsError,
    zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCertificateAuthorityAuditReport(request))
  def deleteCertificateAuthority(
      request: zio.aws.acmpca.model.DeleteCertificateAuthorityRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCertificateAuthority(request))
  def tagCertificateAuthority(
      request: zio.aws.acmpca.model.TagCertificateAuthorityRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagCertificateAuthority(request))
  def untagCertificateAuthority(
      request: zio.aws.acmpca.model.UntagCertificateAuthorityRequest
  ): ZIO[zio.aws.acmpca.AcmPca, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagCertificateAuthority(request))
}
