package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.{
  String64,
  String3,
  ASN1PrintableString64,
  String128,
  String16,
  CountryCodeString,
  String5,
  String40
}
import scala.jdk.CollectionConverters._
final case class ASN1Subject(
    country: Optional[CountryCodeString] = Optional.Absent,
    organization: Optional[String64] = Optional.Absent,
    organizationalUnit: Optional[String64] = Optional.Absent,
    distinguishedNameQualifier: Optional[ASN1PrintableString64] =
      Optional.Absent,
    state: Optional[String128] = Optional.Absent,
    commonName: Optional[String64] = Optional.Absent,
    serialNumber: Optional[ASN1PrintableString64] = Optional.Absent,
    locality: Optional[String128] = Optional.Absent,
    title: Optional[String64] = Optional.Absent,
    surname: Optional[String40] = Optional.Absent,
    givenName: Optional[String16] = Optional.Absent,
    initials: Optional[String5] = Optional.Absent,
    pseudonym: Optional[String128] = Optional.Absent,
    generationQualifier: Optional[String3] = Optional.Absent,
    customAttributes: Optional[Iterable[zio.aws.acmpca.model.CustomAttribute]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ASN1Subject = {
    import ASN1Subject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ASN1Subject
      .builder()
      .optionallyWith(
        country.map(value => CountryCodeString.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        organization.map(value => String64.unwrap(value): java.lang.String)
      )(_.organization)
      .optionallyWith(
        organizationalUnit.map(value =>
          String64.unwrap(value): java.lang.String
        )
      )(_.organizationalUnit)
      .optionallyWith(
        distinguishedNameQualifier.map(value =>
          ASN1PrintableString64.unwrap(value): java.lang.String
        )
      )(_.distinguishedNameQualifier)
      .optionallyWith(
        state.map(value => String128.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        commonName.map(value => String64.unwrap(value): java.lang.String)
      )(_.commonName)
      .optionallyWith(
        serialNumber.map(value =>
          ASN1PrintableString64.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(
        locality.map(value => String128.unwrap(value): java.lang.String)
      )(_.locality)
      .optionallyWith(
        title.map(value => String64.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        surname.map(value => String40.unwrap(value): java.lang.String)
      )(_.surname)
      .optionallyWith(
        givenName.map(value => String16.unwrap(value): java.lang.String)
      )(_.givenName)
      .optionallyWith(
        initials.map(value => String5.unwrap(value): java.lang.String)
      )(_.initials)
      .optionallyWith(
        pseudonym.map(value => String128.unwrap(value): java.lang.String)
      )(_.pseudonym)
      .optionallyWith(
        generationQualifier.map(value =>
          String3.unwrap(value): java.lang.String
        )
      )(_.generationQualifier)
      .optionallyWith(
        customAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAttributes)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ASN1Subject.ReadOnly =
    zio.aws.acmpca.model.ASN1Subject.wrap(buildAwsValue())
}
object ASN1Subject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ASN1Subject =
      zio.aws.acmpca.model.ASN1Subject(
        country.map(value => value),
        organization.map(value => value),
        organizationalUnit.map(value => value),
        distinguishedNameQualifier.map(value => value),
        state.map(value => value),
        commonName.map(value => value),
        serialNumber.map(value => value),
        locality.map(value => value),
        title.map(value => value),
        surname.map(value => value),
        givenName.map(value => value),
        initials.map(value => value),
        pseudonym.map(value => value),
        generationQualifier.map(value => value),
        customAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def country: Optional[CountryCodeString]
    def organization: Optional[String64]
    def organizationalUnit: Optional[String64]
    def distinguishedNameQualifier: Optional[ASN1PrintableString64]
    def state: Optional[String128]
    def commonName: Optional[String64]
    def serialNumber: Optional[ASN1PrintableString64]
    def locality: Optional[String128]
    def title: Optional[String64]
    def surname: Optional[String40]
    def givenName: Optional[String16]
    def initials: Optional[String5]
    def pseudonym: Optional[String128]
    def generationQualifier: Optional[String3]
    def customAttributes
        : Optional[List[zio.aws.acmpca.model.CustomAttribute.ReadOnly]]
    def getCountry: ZIO[Any, AwsError, CountryCodeString] =
      AwsError.unwrapOptionField("country", country)
    def getOrganization: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("organization", organization)
    def getOrganizationalUnit: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("organizationalUnit", organizationalUnit)
    def getDistinguishedNameQualifier
        : ZIO[Any, AwsError, ASN1PrintableString64] =
      AwsError.unwrapOptionField(
        "distinguishedNameQualifier",
        distinguishedNameQualifier
      )
    def getState: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("state", state)
    def getCommonName: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getSerialNumber: ZIO[Any, AwsError, ASN1PrintableString64] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocality: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("locality", locality)
    def getTitle: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("title", title)
    def getSurname: ZIO[Any, AwsError, String40] =
      AwsError.unwrapOptionField("surname", surname)
    def getGivenName: ZIO[Any, AwsError, String16] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getInitials: ZIO[Any, AwsError, String5] =
      AwsError.unwrapOptionField("initials", initials)
    def getPseudonym: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("pseudonym", pseudonym)
    def getGenerationQualifier: ZIO[Any, AwsError, String3] =
      AwsError.unwrapOptionField("generationQualifier", generationQualifier)
    def getCustomAttributes: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.CustomAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("customAttributes", customAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ) extends zio.aws.acmpca.model.ASN1Subject.ReadOnly {
    override val country: Optional[CountryCodeString] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => zio.aws.acmpca.model.primitives.CountryCodeString(value))
    override val organization: Optional[String64] = zio.aws.core.internal
      .optionalFromNullable(impl.organization())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val organizationalUnit: Optional[String64] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnit())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val distinguishedNameQualifier: Optional[ASN1PrintableString64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distinguishedNameQualifier())
        .map(value =>
          zio.aws.acmpca.model.primitives.ASN1PrintableString64(value)
        )
    override val state: Optional[String128] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val commonName: Optional[String64] = zio.aws.core.internal
      .optionalFromNullable(impl.commonName())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val serialNumber: Optional[ASN1PrintableString64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value =>
          zio.aws.acmpca.model.primitives.ASN1PrintableString64(value)
        )
    override val locality: Optional[String128] = zio.aws.core.internal
      .optionalFromNullable(impl.locality())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val title: Optional[String64] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val surname: Optional[String40] = zio.aws.core.internal
      .optionalFromNullable(impl.surname())
      .map(value => zio.aws.acmpca.model.primitives.String40(value))
    override val givenName: Optional[String16] = zio.aws.core.internal
      .optionalFromNullable(impl.givenName())
      .map(value => zio.aws.acmpca.model.primitives.String16(value))
    override val initials: Optional[String5] = zio.aws.core.internal
      .optionalFromNullable(impl.initials())
      .map(value => zio.aws.acmpca.model.primitives.String5(value))
    override val pseudonym: Optional[String128] = zio.aws.core.internal
      .optionalFromNullable(impl.pseudonym())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val generationQualifier: Optional[String3] = zio.aws.core.internal
      .optionalFromNullable(impl.generationQualifier())
      .map(value => zio.aws.acmpca.model.primitives.String3(value))
    override val customAttributes
        : Optional[List[zio.aws.acmpca.model.CustomAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.CustomAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ): zio.aws.acmpca.model.ASN1Subject.ReadOnly = new Wrapper(impl)
}
