package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait AccessMethodType {
  def unwrap: software.amazon.awssdk.services.acmpca.model.AccessMethodType
}
object AccessMethodType {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.AccessMethodType
  ): zio.aws.acmpca.model.AccessMethodType = value match {
    case software.amazon.awssdk.services.acmpca.model.AccessMethodType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.AccessMethodType.CA_REPOSITORY =>
      val r = CA_REPOSITORY
      r
    case software.amazon.awssdk.services.acmpca.model.AccessMethodType.RESOURCE_PKI_MANIFEST =>
      val r = RESOURCE_PKI_MANIFEST
      r
    case software.amazon.awssdk.services.acmpca.model.AccessMethodType.RESOURCE_PKI_NOTIFY =>
      val r = RESOURCE_PKI_NOTIFY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.AccessMethodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AccessMethodType =
      software.amazon.awssdk.services.acmpca.model.AccessMethodType.UNKNOWN_TO_SDK_VERSION
  }
  case object CA_REPOSITORY extends zio.aws.acmpca.model.AccessMethodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AccessMethodType =
      software.amazon.awssdk.services.acmpca.model.AccessMethodType.CA_REPOSITORY
  }
  case object RESOURCE_PKI_MANIFEST
      extends zio.aws.acmpca.model.AccessMethodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AccessMethodType =
      software.amazon.awssdk.services.acmpca.model.AccessMethodType.RESOURCE_PKI_MANIFEST
  }
  case object RESOURCE_PKI_NOTIFY
      extends zio.aws.acmpca.model.AccessMethodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AccessMethodType =
      software.amazon.awssdk.services.acmpca.model.AccessMethodType.RESOURCE_PKI_NOTIFY
  }
}
