package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait AuditReportResponseFormat {
  def unwrap
      : software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat
}
object AuditReportResponseFormat {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat
  ): zio.aws.acmpca.model.AuditReportResponseFormat = value match {
    case software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.AuditReportResponseFormat {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat =
      software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.acmpca.model.AuditReportResponseFormat {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat =
      software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.JSON
  }
  case object CSV extends zio.aws.acmpca.model.AuditReportResponseFormat {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat =
      software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat.CSV
  }
}
