package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{S3BucketName, Arn}
import scala.jdk.CollectionConverters._
final case class CreateCertificateAuthorityAuditReportRequest(
    certificateAuthorityArn: Arn,
    s3BucketName: S3BucketName,
    auditReportResponseFormat: zio.aws.acmpca.model.AuditReportResponseFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest = {
    import CreateCertificateAuthorityAuditReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .auditReportResponseFormat(auditReportResponseFormat.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest.ReadOnly =
    zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest
      .wrap(buildAwsValue())
}
object CreateCertificateAuthorityAuditReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest =
      zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest(
        certificateAuthorityArn,
        s3BucketName,
        auditReportResponseFormat
      )
    def certificateAuthorityArn: Arn
    def s3BucketName: S3BucketName
    def auditReportResponseFormat
        : zio.aws.acmpca.model.AuditReportResponseFormat
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getAuditReportResponseFormat
        : ZIO[Any, Nothing, zio.aws.acmpca.model.AuditReportResponseFormat] =
      ZIO.succeed(auditReportResponseFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest
  ) extends zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val s3BucketName: S3BucketName =
      zio.aws.acmpca.model.primitives.S3BucketName(impl.s3BucketName())
    override val auditReportResponseFormat
        : zio.aws.acmpca.model.AuditReportResponseFormat =
      zio.aws.acmpca.model.AuditReportResponseFormat
        .wrap(impl.auditReportResponseFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest
  ): zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportRequest.ReadOnly =
    new Wrapper(impl)
}
