package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.{
  Base64String1To4096,
  CustomObjectIdentifier
}
import scala.jdk.CollectionConverters._
final case class CustomExtension(
    objectIdentifier: CustomObjectIdentifier,
    value: Base64String1To4096,
    critical: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CustomExtension = {
    import CustomExtension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CustomExtension
      .builder()
      .objectIdentifier(
        CustomObjectIdentifier.unwrap(objectIdentifier): java.lang.String
      )
      .value(Base64String1To4096.unwrap(value): java.lang.String)
      .optionallyWith(critical.map(value => value: java.lang.Boolean))(
        _.critical
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CustomExtension.ReadOnly =
    zio.aws.acmpca.model.CustomExtension.wrap(buildAwsValue())
}
object CustomExtension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CustomExtension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CustomExtension = zio.aws.acmpca.model
      .CustomExtension(objectIdentifier, value, critical.map(value => value))
    def objectIdentifier: CustomObjectIdentifier
    def value: Base64String1To4096
    def critical: Optional[Boolean]
    def getObjectIdentifier: ZIO[Any, Nothing, CustomObjectIdentifier] =
      ZIO.succeed(objectIdentifier)
    def getValue: ZIO[Any, Nothing, Base64String1To4096] = ZIO.succeed(value)
    def getCritical: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("critical", critical)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CustomExtension
  ) extends zio.aws.acmpca.model.CustomExtension.ReadOnly {
    override val objectIdentifier: CustomObjectIdentifier =
      zio.aws.acmpca.model.primitives
        .CustomObjectIdentifier(impl.objectIdentifier())
    override val value: Base64String1To4096 =
      zio.aws.acmpca.model.primitives.Base64String1To4096(impl.value())
    override val critical: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.critical())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CustomExtension
  ): zio.aws.acmpca.model.CustomExtension.ReadOnly = new Wrapper(impl)
}
