package zio.aws.acmpca.model
import zio.aws.acmpca.model.primitives.{PermanentDeletionTimeInDays, Arn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeleteCertificateAuthorityRequest(
    certificateAuthorityArn: Arn,
    permanentDeletionTimeInDays: Optional[PermanentDeletionTimeInDays] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest = {
    import DeleteCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .optionallyWith(
        permanentDeletionTimeInDays.map(value =>
          PermanentDeletionTimeInDays.unwrap(value): Integer
        )
      )(_.permanentDeletionTimeInDays)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DeleteCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.DeleteCertificateAuthorityRequest.wrap(buildAwsValue())
}
object DeleteCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.DeleteCertificateAuthorityRequest =
      zio.aws.acmpca.model.DeleteCertificateAuthorityRequest(
        certificateAuthorityArn,
        permanentDeletionTimeInDays.map(value => value)
      )
    def certificateAuthorityArn: Arn
    def permanentDeletionTimeInDays: Optional[PermanentDeletionTimeInDays]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getPermanentDeletionTimeInDays
        : ZIO[Any, AwsError, PermanentDeletionTimeInDays] =
      AwsError.unwrapOptionField(
        "permanentDeletionTimeInDays",
        permanentDeletionTimeInDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.DeleteCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val permanentDeletionTimeInDays
        : Optional[PermanentDeletionTimeInDays] = zio.aws.core.internal
      .optionalFromNullable(impl.permanentDeletionTimeInDays())
      .map(value =>
        zio.aws.acmpca.model.primitives.PermanentDeletionTimeInDays(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest
  ): zio.aws.acmpca.model.DeleteCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
