package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.{AccountId, Principal, Arn}
import scala.jdk.CollectionConverters._
final case class DeletePermissionRequest(
    certificateAuthorityArn: Arn,
    principal: Principal,
    sourceAccount: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest = {
    import DeletePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .principal(Principal.unwrap(principal): java.lang.String)
      .optionallyWith(
        sourceAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.DeletePermissionRequest.ReadOnly =
    zio.aws.acmpca.model.DeletePermissionRequest.wrap(buildAwsValue())
}
object DeletePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.DeletePermissionRequest =
      zio.aws.acmpca.model.DeletePermissionRequest(
        certificateAuthorityArn,
        principal,
        sourceAccount.map(value => value)
      )
    def certificateAuthorityArn: Arn
    def principal: Principal
    def sourceAccount: Optional[AccountId]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
    def getSourceAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest
  ) extends zio.aws.acmpca.model.DeletePermissionRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val principal: Principal =
      zio.aws.acmpca.model.primitives.Principal(impl.principal())
    override val sourceAccount: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccount())
      .map(value => zio.aws.acmpca.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest
  ): zio.aws.acmpca.model.DeletePermissionRequest.ReadOnly = new Wrapper(impl)
}
