package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DeletePolicyRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.DeletePolicyRequest.ReadOnly =
    zio.aws.acmpca.model.DeletePolicyRequest.wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.DeletePolicyRequest =
      zio.aws.acmpca.model.DeletePolicyRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest
  ) extends zio.aws.acmpca.model.DeletePolicyRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest
  ): zio.aws.acmpca.model.DeletePolicyRequest.ReadOnly = new Wrapper(impl)
}
