package zio.aws.acmpca.model
import zio.aws.acmpca.model.primitives.{TStamp, S3Key, S3BucketName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeCertificateAuthorityAuditReportResponse(
    auditReportStatus: Optional[zio.aws.acmpca.model.AuditReportStatus] =
      Optional.Absent,
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    createdAt: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse = {
    import DescribeCertificateAuthorityAuditReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
      .builder()
      .optionallyWith(auditReportStatus.map(value => value.unwrap))(
        _.auditReportStatus
      )
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly =
    zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
      .wrap(buildAwsValue())
}
object DescribeCertificateAuthorityAuditReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse =
      zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse(
        auditReportStatus.map(value => value),
        s3BucketName.map(value => value),
        s3Key.map(value => value),
        createdAt.map(value => value)
      )
    def auditReportStatus: Optional[zio.aws.acmpca.model.AuditReportStatus]
    def s3BucketName: Optional[S3BucketName]
    def s3Key: Optional[S3Key]
    def createdAt: Optional[TStamp]
    def getAuditReportStatus
        : ZIO[Any, AwsError, zio.aws.acmpca.model.AuditReportStatus] =
      AwsError.unwrapOptionField("auditReportStatus", auditReportStatus)
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ) extends zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly {
    override val auditReportStatus
        : Optional[zio.aws.acmpca.model.AuditReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditReportStatus())
        .map(value => zio.aws.acmpca.model.AuditReportStatus.wrap(value))
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.acmpca.model.primitives.S3BucketName(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.acmpca.model.primitives.S3Key(value))
    override val createdAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ): zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly =
    new Wrapper(impl)
}
