package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetCertificateAuthorityCertificateRequest(
    certificateAuthorityArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest = {
    import GetCertificateAuthorityCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest.ReadOnly =
    zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest
      .wrap(buildAwsValue())
}
object GetCertificateAuthorityCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest =
      zio.aws.acmpca.model
        .GetCertificateAuthorityCertificateRequest(certificateAuthorityArn)
    def certificateAuthorityArn: Arn
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest
  ) extends zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest
  ): zio.aws.acmpca.model.GetCertificateAuthorityCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
