package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetCertificateAuthorityCsrRequest(
    certificateAuthorityArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest = {
    import GetCertificateAuthorityCsrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest.ReadOnly =
    zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest.wrap(buildAwsValue())
}
object GetCertificateAuthorityCsrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest =
      zio.aws.acmpca.model
        .GetCertificateAuthorityCsrRequest(certificateAuthorityArn)
    def certificateAuthorityArn: Arn
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest
  ) extends zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest
  ): zio.aws.acmpca.model.GetCertificateAuthorityCsrRequest.ReadOnly =
    new Wrapper(impl)
}
