package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetCertificateRequest(
    certificateAuthorityArn: Arn,
    certificateArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetCertificateRequest = {
    import GetCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetCertificateRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.GetCertificateRequest.ReadOnly =
    zio.aws.acmpca.model.GetCertificateRequest.wrap(buildAwsValue())
}
object GetCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GetCertificateRequest =
      zio.aws.acmpca.model
        .GetCertificateRequest(certificateAuthorityArn, certificateArn)
    def certificateAuthorityArn: Arn
    def certificateArn: Arn
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateRequest
  ) extends zio.aws.acmpca.model.GetCertificateRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val certificateArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateRequest
  ): zio.aws.acmpca.model.GetCertificateRequest.ReadOnly = new Wrapper(impl)
}
