package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetPolicyRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetPolicyRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.GetPolicyRequest.ReadOnly =
    zio.aws.acmpca.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GetPolicyRequest =
      zio.aws.acmpca.model.GetPolicyRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetPolicyRequest
  ) extends zio.aws.acmpca.model.GetPolicyRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetPolicyRequest
  ): zio.aws.acmpca.model.GetPolicyRequest.ReadOnly = new Wrapper(impl)
}
