package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait KeyAlgorithm {
  def unwrap: software.amazon.awssdk.services.acmpca.model.KeyAlgorithm
}
object KeyAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.KeyAlgorithm
  ): zio.aws.acmpca.model.KeyAlgorithm = value match {
    case software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.RSA_2048 =>
      val r = RSA_2048
      r
    case software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.RSA_4096 =>
      val r = RSA_4096
      r
    case software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.EC_PRIME256_V1 =>
      val r = EC_prime256v1
      r
    case software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.EC_SECP384_R1 =>
      val r = EC_secp384r1
      r
  }
  case object unknownToSdkVersion extends zio.aws.acmpca.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyAlgorithm =
      software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_2048 extends zio.aws.acmpca.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyAlgorithm =
      software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.RSA_2048
  }
  case object RSA_4096 extends zio.aws.acmpca.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyAlgorithm =
      software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.RSA_4096
  }
  case object EC_prime256v1 extends zio.aws.acmpca.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyAlgorithm =
      software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.EC_PRIME256_V1
  }
  case object EC_secp384r1 extends zio.aws.acmpca.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyAlgorithm =
      software.amazon.awssdk.services.acmpca.model.KeyAlgorithm.EC_SECP384_R1
  }
}
