package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait KeyStorageSecurityStandard {
  def unwrap
      : software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard
}
object KeyStorageSecurityStandard {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard
  ): zio.aws.acmpca.model.KeyStorageSecurityStandard = value match {
    case software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.FIPS_140_2_LEVEL_2_OR_HIGHER =>
      val r = FIPS_140_2_LEVEL_2_OR_HIGHER
      r
    case software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.FIPS_140_2_LEVEL_3_OR_HIGHER =>
      val r = FIPS_140_2_LEVEL_3_OR_HIGHER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.KeyStorageSecurityStandard {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard =
      software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.UNKNOWN_TO_SDK_VERSION
  }
  case object FIPS_140_2_LEVEL_2_OR_HIGHER
      extends zio.aws.acmpca.model.KeyStorageSecurityStandard {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard =
      software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.FIPS_140_2_LEVEL_2_OR_HIGHER
  }
  case object FIPS_140_2_LEVEL_3_OR_HIGHER
      extends zio.aws.acmpca.model.KeyStorageSecurityStandard {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard =
      software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard.FIPS_140_2_LEVEL_3_OR_HIGHER
  }
}
