package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyUsage(
    digitalSignature: Optional[Boolean] = Optional.Absent,
    nonRepudiation: Optional[Boolean] = Optional.Absent,
    keyEncipherment: Optional[Boolean] = Optional.Absent,
    dataEncipherment: Optional[Boolean] = Optional.Absent,
    keyAgreement: Optional[Boolean] = Optional.Absent,
    keyCertSign: Optional[Boolean] = Optional.Absent,
    crlSign: Optional[Boolean] = Optional.Absent,
    encipherOnly: Optional[Boolean] = Optional.Absent,
    decipherOnly: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.acmpca.model.KeyUsage = {
    import KeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.KeyUsage
      .builder()
      .optionallyWith(digitalSignature.map(value => value: java.lang.Boolean))(
        _.digitalSignature
      )
      .optionallyWith(nonRepudiation.map(value => value: java.lang.Boolean))(
        _.nonRepudiation
      )
      .optionallyWith(keyEncipherment.map(value => value: java.lang.Boolean))(
        _.keyEncipherment
      )
      .optionallyWith(dataEncipherment.map(value => value: java.lang.Boolean))(
        _.dataEncipherment
      )
      .optionallyWith(keyAgreement.map(value => value: java.lang.Boolean))(
        _.keyAgreement
      )
      .optionallyWith(keyCertSign.map(value => value: java.lang.Boolean))(
        _.keyCertSign
      )
      .optionallyWith(crlSign.map(value => value: java.lang.Boolean))(_.crlSign)
      .optionallyWith(encipherOnly.map(value => value: java.lang.Boolean))(
        _.encipherOnly
      )
      .optionallyWith(decipherOnly.map(value => value: java.lang.Boolean))(
        _.decipherOnly
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.KeyUsage.ReadOnly =
    zio.aws.acmpca.model.KeyUsage.wrap(buildAwsValue())
}
object KeyUsage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.KeyUsage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.KeyUsage =
      zio.aws.acmpca.model.KeyUsage(
        digitalSignature.map(value => value),
        nonRepudiation.map(value => value),
        keyEncipherment.map(value => value),
        dataEncipherment.map(value => value),
        keyAgreement.map(value => value),
        keyCertSign.map(value => value),
        crlSign.map(value => value),
        encipherOnly.map(value => value),
        decipherOnly.map(value => value)
      )
    def digitalSignature: Optional[Boolean]
    def nonRepudiation: Optional[Boolean]
    def keyEncipherment: Optional[Boolean]
    def dataEncipherment: Optional[Boolean]
    def keyAgreement: Optional[Boolean]
    def keyCertSign: Optional[Boolean]
    def crlSign: Optional[Boolean]
    def encipherOnly: Optional[Boolean]
    def decipherOnly: Optional[Boolean]
    def getDigitalSignature: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("digitalSignature", digitalSignature)
    def getNonRepudiation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("nonRepudiation", nonRepudiation)
    def getKeyEncipherment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyEncipherment", keyEncipherment)
    def getDataEncipherment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataEncipherment", dataEncipherment)
    def getKeyAgreement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyAgreement", keyAgreement)
    def getKeyCertSign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyCertSign", keyCertSign)
    def getCrlSign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crlSign", crlSign)
    def getEncipherOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encipherOnly", encipherOnly)
    def getDecipherOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("decipherOnly", decipherOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.KeyUsage
  ) extends zio.aws.acmpca.model.KeyUsage.ReadOnly {
    override val digitalSignature: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.digitalSignature())
      .map(value => value: Boolean)
    override val nonRepudiation: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.nonRepudiation())
      .map(value => value: Boolean)
    override val keyEncipherment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.keyEncipherment())
      .map(value => value: Boolean)
    override val dataEncipherment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEncipherment())
      .map(value => value: Boolean)
    override val keyAgreement: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.keyAgreement())
      .map(value => value: Boolean)
    override val keyCertSign: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.keyCertSign())
      .map(value => value: Boolean)
    override val crlSign: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crlSign())
      .map(value => value: Boolean)
    override val encipherOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encipherOnly())
      .map(value => value: Boolean)
    override val decipherOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.decipherOnly())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.KeyUsage
  ): zio.aws.acmpca.model.KeyUsage.ReadOnly = new Wrapper(impl)
}
