package zio.aws.acmpca.model
import zio.aws.acmpca.model.primitives.{MaxResults, NextToken, Arn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    certificateAuthorityArn: Arn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ListPermissionsRequest.ReadOnly =
    zio.aws.acmpca.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ListPermissionsRequest =
      zio.aws.acmpca.model.ListPermissionsRequest(
        certificateAuthorityArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def certificateAuthorityArn: Arn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest
  ) extends zio.aws.acmpca.model.ListPermissionsRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.acmpca.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.acmpca.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest
  ): zio.aws.acmpca.model.ListPermissionsRequest.ReadOnly = new Wrapper(impl)
}
