package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPermissionsResponse(
    permissions: Optional[Iterable[zio.aws.acmpca.model.Permission]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse = {
    import ListPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse
      .builder()
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly =
    zio.aws.acmpca.model.ListPermissionsResponse.wrap(buildAwsValue())
}
object ListPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ListPermissionsResponse =
      zio.aws.acmpca.model.ListPermissionsResponse(
        permissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissions: Optional[List[zio.aws.acmpca.model.Permission.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.acmpca.model.Permission.ReadOnly]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse
  ) extends zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly {
    override val permissions
        : Optional[List[zio.aws.acmpca.model.Permission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.Permission.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.acmpca.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse
  ): zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly = new Wrapper(impl)
}
