package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{String256, CustomObjectIdentifier}
import scala.jdk.CollectionConverters._
final case class OtherName(typeId: CustomObjectIdentifier, value: String256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.OtherName = {
    import OtherName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.OtherName
      .builder()
      .typeId(CustomObjectIdentifier.unwrap(typeId): java.lang.String)
      .value(String256.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.OtherName.ReadOnly =
    zio.aws.acmpca.model.OtherName.wrap(buildAwsValue())
}
object OtherName {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.OtherName] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.OtherName =
      zio.aws.acmpca.model.OtherName(typeId, value)
    def typeId: CustomObjectIdentifier
    def value: String256
    def getTypeId: ZIO[Any, Nothing, CustomObjectIdentifier] =
      ZIO.succeed(typeId)
    def getValue: ZIO[Any, Nothing, String256] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.OtherName
  ) extends zio.aws.acmpca.model.OtherName.ReadOnly {
    override val typeId: CustomObjectIdentifier =
      zio.aws.acmpca.model.primitives.CustomObjectIdentifier(impl.typeId())
    override val value: String256 =
      zio.aws.acmpca.model.primitives.String256(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.OtherName
  ): zio.aws.acmpca.model.OtherName.ReadOnly = new Wrapper(impl)
}
