package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.CustomObjectIdentifier
import scala.jdk.CollectionConverters._
final case class PolicyInformation(
    certPolicyId: CustomObjectIdentifier,
    policyQualifiers: Optional[
      Iterable[zio.aws.acmpca.model.PolicyQualifierInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.PolicyInformation = {
    import PolicyInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.PolicyInformation
      .builder()
      .certPolicyId(
        CustomObjectIdentifier.unwrap(certPolicyId): java.lang.String
      )
      .optionallyWith(
        policyQualifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyQualifiers)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.PolicyInformation.ReadOnly =
    zio.aws.acmpca.model.PolicyInformation.wrap(buildAwsValue())
}
object PolicyInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.PolicyInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.PolicyInformation =
      zio.aws.acmpca.model.PolicyInformation(
        certPolicyId,
        policyQualifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certPolicyId: CustomObjectIdentifier
    def policyQualifiers
        : Optional[List[zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly]]
    def getCertPolicyId: ZIO[Any, Nothing, CustomObjectIdentifier] =
      ZIO.succeed(certPolicyId)
    def getPolicyQualifiers: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("policyQualifiers", policyQualifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.PolicyInformation
  ) extends zio.aws.acmpca.model.PolicyInformation.ReadOnly {
    override val certPolicyId: CustomObjectIdentifier =
      zio.aws.acmpca.model.primitives
        .CustomObjectIdentifier(impl.certPolicyId())
    override val policyQualifiers
        : Optional[List[zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyQualifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.PolicyQualifierInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.PolicyInformation
  ): zio.aws.acmpca.model.PolicyInformation.ReadOnly = new Wrapper(impl)
}
