package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{AWSPolicy, Arn}
import scala.jdk.CollectionConverters._
final case class PutPolicyRequest(resourceArn: Arn, policy: AWSPolicy) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.PutPolicyRequest = {
    import PutPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.PutPolicyRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .policy(AWSPolicy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.PutPolicyRequest.ReadOnly =
    zio.aws.acmpca.model.PutPolicyRequest.wrap(buildAwsValue())
}
object PutPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.PutPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.PutPolicyRequest =
      zio.aws.acmpca.model.PutPolicyRequest(resourceArn, policy)
    def resourceArn: Arn
    def policy: AWSPolicy
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, AWSPolicy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.PutPolicyRequest
  ) extends zio.aws.acmpca.model.PutPolicyRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.resourceArn())
    override val policy: AWSPolicy =
      zio.aws.acmpca.model.primitives.AWSPolicy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.PutPolicyRequest
  ): zio.aws.acmpca.model.PutPolicyRequest.ReadOnly = new Wrapper(impl)
}
