package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{String128, Arn}
import scala.jdk.CollectionConverters._
final case class RevokeCertificateRequest(
    certificateAuthorityArn: Arn,
    certificateSerial: String128,
    revocationReason: zio.aws.acmpca.model.RevocationReason
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest = {
    import RevokeCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .certificateSerial(String128.unwrap(certificateSerial): java.lang.String)
      .revocationReason(revocationReason.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.RevokeCertificateRequest.ReadOnly =
    zio.aws.acmpca.model.RevokeCertificateRequest.wrap(buildAwsValue())
}
object RevokeCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.RevokeCertificateRequest =
      zio.aws.acmpca.model.RevokeCertificateRequest(
        certificateAuthorityArn,
        certificateSerial,
        revocationReason
      )
    def certificateAuthorityArn: Arn
    def certificateSerial: String128
    def revocationReason: zio.aws.acmpca.model.RevocationReason
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getCertificateSerial: ZIO[Any, Nothing, String128] =
      ZIO.succeed(certificateSerial)
    def getRevocationReason
        : ZIO[Any, Nothing, zio.aws.acmpca.model.RevocationReason] =
      ZIO.succeed(revocationReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest
  ) extends zio.aws.acmpca.model.RevokeCertificateRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val certificateSerial: String128 =
      zio.aws.acmpca.model.primitives.String128(impl.certificateSerial())
    override val revocationReason: zio.aws.acmpca.model.RevocationReason =
      zio.aws.acmpca.model.RevocationReason.wrap(impl.revocationReason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest
  ): zio.aws.acmpca.model.RevokeCertificateRequest.ReadOnly = new Wrapper(impl)
}
