package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait SigningAlgorithm {
  def unwrap: software.amazon.awssdk.services.acmpca.model.SigningAlgorithm
}
object SigningAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.SigningAlgorithm
  ): zio.aws.acmpca.model.SigningAlgorithm = value match {
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA256_WITHECDSA =>
      val r = SHA256WITHECDSA
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA384_WITHECDSA =>
      val r = SHA384WITHECDSA
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA512_WITHECDSA =>
      val r = SHA512WITHECDSA
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA256_WITHRSA =>
      val r = SHA256WITHRSA
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA384_WITHRSA =>
      val r = SHA384WITHRSA
      r
    case software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA512_WITHRSA =>
      val r = SHA512WITHRSA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object SHA256WITHECDSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA256_WITHECDSA
  }
  case object SHA384WITHECDSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA384_WITHECDSA
  }
  case object SHA512WITHECDSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA512_WITHECDSA
  }
  case object SHA256WITHRSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA256_WITHRSA
  }
  case object SHA384WITHRSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA384_WITHRSA
  }
  case object SHA512WITHRSA extends zio.aws.acmpca.model.SigningAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.SigningAlgorithm =
      software.amazon.awssdk.services.acmpca.model.SigningAlgorithm.SHA512_WITHRSA
  }
}
