package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UntagCertificateAuthorityRequest(
    certificateAuthorityArn: Arn,
    tags: Iterable[zio.aws.acmpca.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest = {
    import UntagCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.UntagCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.UntagCertificateAuthorityRequest.wrap(buildAwsValue())
}
object UntagCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.UntagCertificateAuthorityRequest =
      zio.aws.acmpca.model.UntagCertificateAuthorityRequest(
        certificateAuthorityArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def certificateAuthorityArn: Arn
    def tags: List[zio.aws.acmpca.model.Tag.ReadOnly]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.acmpca.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.UntagCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val tags: List[zio.aws.acmpca.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.acmpca.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest
  ): zio.aws.acmpca.model.UntagCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
