package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UpdateCertificateAuthorityRequest(
    certificateAuthorityArn: Arn,
    revocationConfiguration: Optional[
      zio.aws.acmpca.model.RevocationConfiguration
    ] = Optional.Absent,
    status: Optional[zio.aws.acmpca.model.CertificateAuthorityStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest = {
    import UpdateCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .optionallyWith(
        revocationConfiguration.map(value => value.buildAwsValue())
      )(_.revocationConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.UpdateCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.UpdateCertificateAuthorityRequest.wrap(buildAwsValue())
}
object UpdateCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.UpdateCertificateAuthorityRequest =
      zio.aws.acmpca.model.UpdateCertificateAuthorityRequest(
        certificateAuthorityArn,
        revocationConfiguration.map(value => value.asEditable),
        status.map(value => value)
      )
    def certificateAuthorityArn: Arn
    def revocationConfiguration
        : Optional[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly]
    def status: Optional[zio.aws.acmpca.model.CertificateAuthorityStatus]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getRevocationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.RevocationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "revocationConfiguration",
      revocationConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CertificateAuthorityStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.UpdateCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val revocationConfiguration
        : Optional[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revocationConfiguration())
        .map(value => zio.aws.acmpca.model.RevocationConfiguration.wrap(value))
    override val status
        : Optional[zio.aws.acmpca.model.CertificateAuthorityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.acmpca.model.CertificateAuthorityStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest
  ): zio.aws.acmpca.model.UpdateCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
