package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.String256
import scala.jdk.CollectionConverters._
final case class EdiPartyName(
    partyName: String256,
    nameAssigner: Optional[String256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.EdiPartyName = {
    import EdiPartyName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.EdiPartyName
      .builder()
      .partyName(String256.unwrap(partyName): java.lang.String)
      .optionallyWith(
        nameAssigner.map(value => String256.unwrap(value): java.lang.String)
      )(_.nameAssigner)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.EdiPartyName.ReadOnly =
    zio.aws.acmpca.model.EdiPartyName.wrap(buildAwsValue())
}
object EdiPartyName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.EdiPartyName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.EdiPartyName = zio.aws.acmpca.model
      .EdiPartyName(partyName, nameAssigner.map(value => value))
    def partyName: String256
    def nameAssigner: Optional[String256]
    def getPartyName: ZIO[Any, Nothing, String256] = ZIO.succeed(partyName)
    def getNameAssigner: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("nameAssigner", nameAssigner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.EdiPartyName
  ) extends zio.aws.acmpca.model.EdiPartyName.ReadOnly {
    override val partyName: String256 =
      zio.aws.acmpca.model.primitives.String256(impl.partyName())
    override val nameAssigner: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.nameAssigner())
      .map(value => zio.aws.acmpca.model.primitives.String256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.EdiPartyName
  ): zio.aws.acmpca.model.EdiPartyName.ReadOnly = new Wrapper(impl)
}
