package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait S3ObjectAcl {
  def unwrap: software.amazon.awssdk.services.acmpca.model.S3ObjectAcl
}
object S3ObjectAcl {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.S3ObjectAcl
  ): zio.aws.acmpca.model.S3ObjectAcl = value match {
    case software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.PUBLIC_READ =>
      val r = PUBLIC_READ
      r
    case software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.BUCKET_OWNER_FULL_CONTROL =>
      val r = BUCKET_OWNER_FULL_CONTROL
      r
  }
  case object unknownToSdkVersion extends zio.aws.acmpca.model.S3ObjectAcl {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.S3ObjectAcl =
      software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC_READ extends zio.aws.acmpca.model.S3ObjectAcl {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.S3ObjectAcl =
      software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.PUBLIC_READ
  }
  case object BUCKET_OWNER_FULL_CONTROL
      extends zio.aws.acmpca.model.S3ObjectAcl {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.S3ObjectAcl =
      software.amazon.awssdk.services.acmpca.model.S3ObjectAcl.BUCKET_OWNER_FULL_CONTROL
  }
}
