package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.PositiveLong
import scala.jdk.CollectionConverters._
final case class Validity(
    value: PositiveLong,
    `type`: zio.aws.acmpca.model.ValidityPeriodType
) {
  def buildAwsValue(): software.amazon.awssdk.services.acmpca.model.Validity = {
    import Validity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.Validity
      .builder()
      .value(PositiveLong.unwrap(value): java.lang.Long)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.Validity.ReadOnly =
    zio.aws.acmpca.model.Validity.wrap(buildAwsValue())
}
object Validity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.Validity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.Validity =
      zio.aws.acmpca.model.Validity(value, `type`)
    def value: PositiveLong
    def `type`: zio.aws.acmpca.model.ValidityPeriodType
    def getValue: ZIO[Any, Nothing, PositiveLong] = ZIO.succeed(value)
    def getType: ZIO[Any, Nothing, zio.aws.acmpca.model.ValidityPeriodType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.Validity
  ) extends zio.aws.acmpca.model.Validity.ReadOnly {
    override val value: PositiveLong =
      zio.aws.acmpca.model.primitives.PositiveLong(impl.value())
    override val `type`: zio.aws.acmpca.model.ValidityPeriodType =
      zio.aws.acmpca.model.ValidityPeriodType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.Validity
  ): zio.aws.acmpca.model.Validity.ReadOnly = new Wrapper(impl)
}
