package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait ValidityPeriodType {
  def unwrap: software.amazon.awssdk.services.acmpca.model.ValidityPeriodType
}
object ValidityPeriodType {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.ValidityPeriodType
  ): zio.aws.acmpca.model.ValidityPeriodType = value match {
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.END_DATE =>
      val r = END_DATE
      r
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.ABSOLUTE =>
      val r = ABSOLUTE
      r
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.DAYS =>
      val r = DAYS
      r
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.MONTHS =>
      val r = MONTHS
      r
    case software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.YEARS =>
      val r = YEARS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.UNKNOWN_TO_SDK_VERSION
  }
  case object END_DATE extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.END_DATE
  }
  case object ABSOLUTE extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.ABSOLUTE
  }
  case object DAYS extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.DAYS
  }
  case object MONTHS extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.MONTHS
  }
  case object YEARS extends zio.aws.acmpca.model.ValidityPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ValidityPeriodType =
      software.amazon.awssdk.services.acmpca.model.ValidityPeriodType.YEARS
  }
}
