package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{
  String64,
  String3,
  ASN1PrintableString64,
  String128,
  String16,
  CountryCodeString,
  String5,
  String40
}
import scala.jdk.CollectionConverters._
final case class ASN1Subject(
    country: Option[CountryCodeString] = None,
    organization: Option[String64] = None,
    organizationalUnit: Option[String64] = None,
    distinguishedNameQualifier: Option[ASN1PrintableString64] = None,
    state: Option[String128] = None,
    commonName: Option[String64] = None,
    serialNumber: Option[ASN1PrintableString64] = None,
    locality: Option[String128] = None,
    title: Option[String64] = None,
    surname: Option[String40] = None,
    givenName: Option[String16] = None,
    initials: Option[String5] = None,
    pseudonym: Option[String128] = None,
    generationQualifier: Option[String3] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ASN1Subject = {
    import ASN1Subject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ASN1Subject
      .builder()
      .optionallyWith(
        country.map(value => CountryCodeString.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        organization.map(value => String64.unwrap(value): java.lang.String)
      )(_.organization)
      .optionallyWith(
        organizationalUnit.map(value =>
          String64.unwrap(value): java.lang.String
        )
      )(_.organizationalUnit)
      .optionallyWith(
        distinguishedNameQualifier.map(value =>
          ASN1PrintableString64.unwrap(value): java.lang.String
        )
      )(_.distinguishedNameQualifier)
      .optionallyWith(
        state.map(value => String128.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        commonName.map(value => String64.unwrap(value): java.lang.String)
      )(_.commonName)
      .optionallyWith(
        serialNumber.map(value =>
          ASN1PrintableString64.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(
        locality.map(value => String128.unwrap(value): java.lang.String)
      )(_.locality)
      .optionallyWith(
        title.map(value => String64.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        surname.map(value => String40.unwrap(value): java.lang.String)
      )(_.surname)
      .optionallyWith(
        givenName.map(value => String16.unwrap(value): java.lang.String)
      )(_.givenName)
      .optionallyWith(
        initials.map(value => String5.unwrap(value): java.lang.String)
      )(_.initials)
      .optionallyWith(
        pseudonym.map(value => String128.unwrap(value): java.lang.String)
      )(_.pseudonym)
      .optionallyWith(
        generationQualifier.map(value =>
          String3.unwrap(value): java.lang.String
        )
      )(_.generationQualifier)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ASN1Subject.ReadOnly =
    zio.aws.acmpca.model.ASN1Subject.wrap(buildAwsValue())
}
object ASN1Subject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ASN1Subject =
      zio.aws.acmpca.model.ASN1Subject(
        country.map(value => value),
        organization.map(value => value),
        organizationalUnit.map(value => value),
        distinguishedNameQualifier.map(value => value),
        state.map(value => value),
        commonName.map(value => value),
        serialNumber.map(value => value),
        locality.map(value => value),
        title.map(value => value),
        surname.map(value => value),
        givenName.map(value => value),
        initials.map(value => value),
        pseudonym.map(value => value),
        generationQualifier.map(value => value)
      )
    def country: Option[CountryCodeString]
    def organization: Option[String64]
    def organizationalUnit: Option[String64]
    def distinguishedNameQualifier: Option[ASN1PrintableString64]
    def state: Option[String128]
    def commonName: Option[String64]
    def serialNumber: Option[ASN1PrintableString64]
    def locality: Option[String128]
    def title: Option[String64]
    def surname: Option[String40]
    def givenName: Option[String16]
    def initials: Option[String5]
    def pseudonym: Option[String128]
    def generationQualifier: Option[String3]
    def getCountry: ZIO[Any, AwsError, CountryCodeString] =
      AwsError.unwrapOptionField("country", country)
    def getOrganization: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("organization", organization)
    def getOrganizationalUnit: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("organizationalUnit", organizationalUnit)
    def getDistinguishedNameQualifier
        : ZIO[Any, AwsError, ASN1PrintableString64] =
      AwsError.unwrapOptionField(
        "distinguishedNameQualifier",
        distinguishedNameQualifier
      )
    def getState: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("state", state)
    def getCommonName: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getSerialNumber: ZIO[Any, AwsError, ASN1PrintableString64] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocality: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("locality", locality)
    def getTitle: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("title", title)
    def getSurname: ZIO[Any, AwsError, String40] =
      AwsError.unwrapOptionField("surname", surname)
    def getGivenName: ZIO[Any, AwsError, String16] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getInitials: ZIO[Any, AwsError, String5] =
      AwsError.unwrapOptionField("initials", initials)
    def getPseudonym: ZIO[Any, AwsError, String128] =
      AwsError.unwrapOptionField("pseudonym", pseudonym)
    def getGenerationQualifier: ZIO[Any, AwsError, String3] =
      AwsError.unwrapOptionField("generationQualifier", generationQualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ) extends zio.aws.acmpca.model.ASN1Subject.ReadOnly {
    override val country: Option[CountryCodeString] = scala
      .Option(impl.country())
      .map(value => zio.aws.acmpca.model.primitives.CountryCodeString(value))
    override val organization: Option[String64] = scala
      .Option(impl.organization())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val organizationalUnit: Option[String64] = scala
      .Option(impl.organizationalUnit())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val distinguishedNameQualifier: Option[ASN1PrintableString64] =
      scala
        .Option(impl.distinguishedNameQualifier())
        .map(value =>
          zio.aws.acmpca.model.primitives.ASN1PrintableString64(value)
        )
    override val state: Option[String128] = scala
      .Option(impl.state())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val commonName: Option[String64] = scala
      .Option(impl.commonName())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val serialNumber: Option[ASN1PrintableString64] = scala
      .Option(impl.serialNumber())
      .map(value =>
        zio.aws.acmpca.model.primitives.ASN1PrintableString64(value)
      )
    override val locality: Option[String128] = scala
      .Option(impl.locality())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val title: Option[String64] = scala
      .Option(impl.title())
      .map(value => zio.aws.acmpca.model.primitives.String64(value))
    override val surname: Option[String40] = scala
      .Option(impl.surname())
      .map(value => zio.aws.acmpca.model.primitives.String40(value))
    override val givenName: Option[String16] = scala
      .Option(impl.givenName())
      .map(value => zio.aws.acmpca.model.primitives.String16(value))
    override val initials: Option[String5] = scala
      .Option(impl.initials())
      .map(value => zio.aws.acmpca.model.primitives.String5(value))
    override val pseudonym: Option[String128] = scala
      .Option(impl.pseudonym())
      .map(value => zio.aws.acmpca.model.primitives.String128(value))
    override val generationQualifier: Option[String3] = scala
      .Option(impl.generationQualifier())
      .map(value => zio.aws.acmpca.model.primitives.String3(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ASN1Subject
  ): zio.aws.acmpca.model.ASN1Subject.ReadOnly = new Wrapper(impl)
}
