package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AccessDescription(
    accessMethod: zio.aws.acmpca.model.AccessMethod,
    accessLocation: zio.aws.acmpca.model.GeneralName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.AccessDescription = {
    import AccessDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.AccessDescription
      .builder()
      .accessMethod(accessMethod.buildAwsValue())
      .accessLocation(accessLocation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.AccessDescription.ReadOnly =
    zio.aws.acmpca.model.AccessDescription.wrap(buildAwsValue())
}
object AccessDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.AccessDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.AccessDescription =
      zio.aws.acmpca.model
        .AccessDescription(accessMethod.asEditable, accessLocation.asEditable)
    def accessMethod: zio.aws.acmpca.model.AccessMethod.ReadOnly
    def accessLocation: zio.aws.acmpca.model.GeneralName.ReadOnly
    def getAccessMethod
        : ZIO[Any, Nothing, zio.aws.acmpca.model.AccessMethod.ReadOnly] =
      ZIO.succeed(accessMethod)
    def getAccessLocation
        : ZIO[Any, Nothing, zio.aws.acmpca.model.GeneralName.ReadOnly] =
      ZIO.succeed(accessLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.AccessDescription
  ) extends zio.aws.acmpca.model.AccessDescription.ReadOnly {
    override val accessMethod: zio.aws.acmpca.model.AccessMethod.ReadOnly =
      zio.aws.acmpca.model.AccessMethod.wrap(impl.accessMethod())
    override val accessLocation: zio.aws.acmpca.model.GeneralName.ReadOnly =
      zio.aws.acmpca.model.GeneralName.wrap(impl.accessLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.AccessDescription
  ): zio.aws.acmpca.model.AccessDescription.ReadOnly = new Wrapper(impl)
}
