package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApiPassthrough(
    extensions: Option[zio.aws.acmpca.model.Extensions] = None,
    subject: Option[zio.aws.acmpca.model.ASN1Subject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ApiPassthrough = {
    import ApiPassthrough.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ApiPassthrough
      .builder()
      .optionallyWith(extensions.map(value => value.buildAwsValue()))(
        _.extensions
      )
      .optionallyWith(subject.map(value => value.buildAwsValue()))(_.subject)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ApiPassthrough.ReadOnly =
    zio.aws.acmpca.model.ApiPassthrough.wrap(buildAwsValue())
}
object ApiPassthrough {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ApiPassthrough
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ApiPassthrough =
      zio.aws.acmpca.model.ApiPassthrough(
        extensions.map(value => value.asEditable),
        subject.map(value => value.asEditable)
      )
    def extensions: Option[zio.aws.acmpca.model.Extensions.ReadOnly]
    def subject: Option[zio.aws.acmpca.model.ASN1Subject.ReadOnly]
    def getExtensions
        : ZIO[Any, AwsError, zio.aws.acmpca.model.Extensions.ReadOnly] =
      AwsError.unwrapOptionField("extensions", extensions)
    def getSubject
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ASN1Subject.ReadOnly] =
      AwsError.unwrapOptionField("subject", subject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ApiPassthrough
  ) extends zio.aws.acmpca.model.ApiPassthrough.ReadOnly {
    override val extensions: Option[zio.aws.acmpca.model.Extensions.ReadOnly] =
      scala
        .Option(impl.extensions())
        .map(value => zio.aws.acmpca.model.Extensions.wrap(value))
    override val subject: Option[zio.aws.acmpca.model.ASN1Subject.ReadOnly] =
      scala
        .Option(impl.subject())
        .map(value => zio.aws.acmpca.model.ASN1Subject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ApiPassthrough
  ): zio.aws.acmpca.model.ApiPassthrough.ReadOnly = new Wrapper(impl)
}
