package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.acmpca.model.primitives.{TStamp, AccountId, Arn}
import scala.jdk.CollectionConverters._
final case class CertificateAuthority(
    arn: Option[Arn] = None,
    ownerAccount: Option[AccountId] = None,
    createdAt: Option[TStamp] = None,
    lastStateChangeAt: Option[TStamp] = None,
    `type`: Option[zio.aws.acmpca.model.CertificateAuthorityType] = None,
    serial: Option[String] = None,
    status: Option[zio.aws.acmpca.model.CertificateAuthorityStatus] = None,
    notBefore: Option[TStamp] = None,
    notAfter: Option[TStamp] = None,
    failureReason: Option[zio.aws.acmpca.model.FailureReason] = None,
    certificateAuthorityConfiguration: Option[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration
    ] = None,
    revocationConfiguration: Option[
      zio.aws.acmpca.model.RevocationConfiguration
    ] = None,
    restorableUntil: Option[TStamp] = None,
    keyStorageSecurityStandard: Option[
      zio.aws.acmpca.model.KeyStorageSecurityStandard
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CertificateAuthority = {
    import CertificateAuthority.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CertificateAuthority
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        ownerAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastStateChangeAt.map(value => TStamp.unwrap(value): Instant)
      )(_.lastStateChangeAt)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(serial.map(value => value: java.lang.String))(_.serial)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(notBefore.map(value => TStamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => TStamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(
        certificateAuthorityConfiguration.map(value => value.buildAwsValue())
      )(_.certificateAuthorityConfiguration)
      .optionallyWith(
        revocationConfiguration.map(value => value.buildAwsValue())
      )(_.revocationConfiguration)
      .optionallyWith(
        restorableUntil.map(value => TStamp.unwrap(value): Instant)
      )(_.restorableUntil)
      .optionallyWith(keyStorageSecurityStandard.map(value => value.unwrap))(
        _.keyStorageSecurityStandard
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CertificateAuthority.ReadOnly =
    zio.aws.acmpca.model.CertificateAuthority.wrap(buildAwsValue())
}
object CertificateAuthority {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CertificateAuthority =
      zio.aws.acmpca.model.CertificateAuthority(
        arn.map(value => value),
        ownerAccount.map(value => value),
        createdAt.map(value => value),
        lastStateChangeAt.map(value => value),
        `type`.map(value => value),
        serial.map(value => value),
        status.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        failureReason.map(value => value),
        certificateAuthorityConfiguration.map(value => value.asEditable),
        revocationConfiguration.map(value => value.asEditable),
        restorableUntil.map(value => value),
        keyStorageSecurityStandard.map(value => value)
      )
    def arn: Option[Arn]
    def ownerAccount: Option[AccountId]
    def createdAt: Option[TStamp]
    def lastStateChangeAt: Option[TStamp]
    def `type`: Option[zio.aws.acmpca.model.CertificateAuthorityType]
    def serial: Option[String]
    def status: Option[zio.aws.acmpca.model.CertificateAuthorityStatus]
    def notBefore: Option[TStamp]
    def notAfter: Option[TStamp]
    def failureReason: Option[zio.aws.acmpca.model.FailureReason]
    def certificateAuthorityConfiguration: Option[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ]
    def revocationConfiguration
        : Option[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly]
    def restorableUntil: Option[TStamp]
    def keyStorageSecurityStandard
        : Option[zio.aws.acmpca.model.KeyStorageSecurityStandard]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getOwnerAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastStateChangeAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastStateChangeAt", lastStateChangeAt)
    def getType
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CertificateAuthorityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serial", serial)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CertificateAuthorityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNotBefore: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getFailureReason
        : ZIO[Any, AwsError, zio.aws.acmpca.model.FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCertificateAuthorityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateAuthorityConfiguration",
      certificateAuthorityConfiguration
    )
    def getRevocationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.RevocationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "revocationConfiguration",
      revocationConfiguration
    )
    def getRestorableUntil: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restorableUntil", restorableUntil)
    def getKeyStorageSecurityStandard
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyStorageSecurityStandard] =
      AwsError.unwrapOptionField(
        "keyStorageSecurityStandard",
        keyStorageSecurityStandard
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ) extends zio.aws.acmpca.model.CertificateAuthority.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
    override val ownerAccount: Option[AccountId] = scala
      .Option(impl.ownerAccount())
      .map(value => zio.aws.acmpca.model.primitives.AccountId(value))
    override val createdAt: Option[TStamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val lastStateChangeAt: Option[TStamp] = scala
      .Option(impl.lastStateChangeAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val `type`: Option[zio.aws.acmpca.model.CertificateAuthorityType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.acmpca.model.CertificateAuthorityType.wrap(value))
    override val serial: Option[String] =
      scala.Option(impl.serial()).map(value => value: String)
    override val status
        : Option[zio.aws.acmpca.model.CertificateAuthorityStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.acmpca.model.CertificateAuthorityStatus.wrap(value))
    override val notBefore: Option[TStamp] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val notAfter: Option[TStamp] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val failureReason: Option[zio.aws.acmpca.model.FailureReason] =
      scala
        .Option(impl.failureReason())
        .map(value => zio.aws.acmpca.model.FailureReason.wrap(value))
    override val certificateAuthorityConfiguration: Option[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ] = scala
      .Option(impl.certificateAuthorityConfiguration())
      .map(value =>
        zio.aws.acmpca.model.CertificateAuthorityConfiguration.wrap(value)
      )
    override val revocationConfiguration
        : Option[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly] = scala
      .Option(impl.revocationConfiguration())
      .map(value => zio.aws.acmpca.model.RevocationConfiguration.wrap(value))
    override val restorableUntil: Option[TStamp] = scala
      .Option(impl.restorableUntil())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val keyStorageSecurityStandard
        : Option[zio.aws.acmpca.model.KeyStorageSecurityStandard] = scala
      .Option(impl.keyStorageSecurityStandard())
      .map(value => zio.aws.acmpca.model.KeyStorageSecurityStandard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ): zio.aws.acmpca.model.CertificateAuthority.ReadOnly = new Wrapper(impl)
}
