package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CertificateAuthorityConfiguration(
    keyAlgorithm: zio.aws.acmpca.model.KeyAlgorithm,
    signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm,
    subject: zio.aws.acmpca.model.ASN1Subject,
    csrExtensions: Option[zio.aws.acmpca.model.CsrExtensions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration = {
    import CertificateAuthorityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration
      .builder()
      .keyAlgorithm(keyAlgorithm.unwrap)
      .signingAlgorithm(signingAlgorithm.unwrap)
      .subject(subject.buildAwsValue())
      .optionallyWith(csrExtensions.map(value => value.buildAwsValue()))(
        _.csrExtensions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly =
    zio.aws.acmpca.model.CertificateAuthorityConfiguration.wrap(buildAwsValue())
}
object CertificateAuthorityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CertificateAuthorityConfiguration =
      zio.aws.acmpca.model.CertificateAuthorityConfiguration(
        keyAlgorithm,
        signingAlgorithm,
        subject.asEditable,
        csrExtensions.map(value => value.asEditable)
      )
    def keyAlgorithm: zio.aws.acmpca.model.KeyAlgorithm
    def signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm
    def subject: zio.aws.acmpca.model.ASN1Subject.ReadOnly
    def csrExtensions: Option[zio.aws.acmpca.model.CsrExtensions.ReadOnly]
    def getKeyAlgorithm: ZIO[Any, Nothing, zio.aws.acmpca.model.KeyAlgorithm] =
      ZIO.succeed(keyAlgorithm)
    def getSigningAlgorithm
        : ZIO[Any, Nothing, zio.aws.acmpca.model.SigningAlgorithm] =
      ZIO.succeed(signingAlgorithm)
    def getSubject
        : ZIO[Any, Nothing, zio.aws.acmpca.model.ASN1Subject.ReadOnly] =
      ZIO.succeed(subject)
    def getCsrExtensions
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CsrExtensions.ReadOnly] =
      AwsError.unwrapOptionField("csrExtensions", csrExtensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration
  ) extends zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly {
    override val keyAlgorithm: zio.aws.acmpca.model.KeyAlgorithm =
      zio.aws.acmpca.model.KeyAlgorithm.wrap(impl.keyAlgorithm())
    override val signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm =
      zio.aws.acmpca.model.SigningAlgorithm.wrap(impl.signingAlgorithm())
    override val subject: zio.aws.acmpca.model.ASN1Subject.ReadOnly =
      zio.aws.acmpca.model.ASN1Subject.wrap(impl.subject())
    override val csrExtensions
        : Option[zio.aws.acmpca.model.CsrExtensions.ReadOnly] = scala
      .Option(impl.csrExtensions())
      .map(value => zio.aws.acmpca.model.CsrExtensions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration
  ): zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly =
    new Wrapper(impl)
}
