package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{S3Key, AuditReportId}
import scala.jdk.CollectionConverters._
final case class CreateCertificateAuthorityAuditReportResponse(
    auditReportId: Option[AuditReportId] = None,
    s3Key: Option[S3Key] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse = {
    import CreateCertificateAuthorityAuditReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
      .builder()
      .optionallyWith(
        auditReportId.map(value =>
          AuditReportId.unwrap(value): java.lang.String
        )
      )(_.auditReportId)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly =
    zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse
      .wrap(buildAwsValue())
}
object CreateCertificateAuthorityAuditReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse =
      zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse(
        auditReportId.map(value => value),
        s3Key.map(value => value)
      )
    def auditReportId: Option[AuditReportId]
    def s3Key: Option[S3Key]
    def getAuditReportId: ZIO[Any, AwsError, AuditReportId] =
      AwsError.unwrapOptionField("auditReportId", auditReportId)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
  ) extends zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly {
    override val auditReportId: Option[AuditReportId] = scala
      .Option(impl.auditReportId())
      .map(value => zio.aws.acmpca.model.primitives.AuditReportId(value))
    override val s3Key: Option[S3Key] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.acmpca.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
  ): zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly =
    new Wrapper(impl)
}
