package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.IdempotencyToken
import scala.jdk.CollectionConverters._
final case class CreateCertificateAuthorityRequest(
    certificateAuthorityConfiguration: zio.aws.acmpca.model.CertificateAuthorityConfiguration,
    revocationConfiguration: Option[
      zio.aws.acmpca.model.RevocationConfiguration
    ] = None,
    certificateAuthorityType: zio.aws.acmpca.model.CertificateAuthorityType,
    idempotencyToken: Option[IdempotencyToken] = None,
    keyStorageSecurityStandard: Option[
      zio.aws.acmpca.model.KeyStorageSecurityStandard
    ] = None,
    tags: Option[Iterable[zio.aws.acmpca.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest = {
    import CreateCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest
      .builder()
      .certificateAuthorityConfiguration(
        certificateAuthorityConfiguration.buildAwsValue()
      )
      .optionallyWith(
        revocationConfiguration.map(value => value.buildAwsValue())
      )(_.revocationConfiguration)
      .certificateAuthorityType(certificateAuthorityType.unwrap)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(keyStorageSecurityStandard.map(value => value.unwrap))(
        _.keyStorageSecurityStandard
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.CreateCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.CreateCertificateAuthorityRequest.wrap(buildAwsValue())
}
object CreateCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CreateCertificateAuthorityRequest =
      zio.aws.acmpca.model.CreateCertificateAuthorityRequest(
        certificateAuthorityConfiguration.asEditable,
        revocationConfiguration.map(value => value.asEditable),
        certificateAuthorityType,
        idempotencyToken.map(value => value),
        keyStorageSecurityStandard.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateAuthorityConfiguration
        : zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    def revocationConfiguration
        : Option[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly]
    def certificateAuthorityType: zio.aws.acmpca.model.CertificateAuthorityType
    def idempotencyToken: Option[IdempotencyToken]
    def keyStorageSecurityStandard
        : Option[zio.aws.acmpca.model.KeyStorageSecurityStandard]
    def tags: Option[List[zio.aws.acmpca.model.Tag.ReadOnly]]
    def getCertificateAuthorityConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ] = ZIO.succeed(certificateAuthorityConfiguration)
    def getRevocationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.RevocationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "revocationConfiguration",
      revocationConfiguration
    )
    def getCertificateAuthorityType
        : ZIO[Any, Nothing, zio.aws.acmpca.model.CertificateAuthorityType] =
      ZIO.succeed(certificateAuthorityType)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getKeyStorageSecurityStandard
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyStorageSecurityStandard] =
      AwsError.unwrapOptionField(
        "keyStorageSecurityStandard",
        keyStorageSecurityStandard
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.acmpca.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.CreateCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityConfiguration
        : zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly =
      zio.aws.acmpca.model.CertificateAuthorityConfiguration
        .wrap(impl.certificateAuthorityConfiguration())
    override val revocationConfiguration
        : Option[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly] = scala
      .Option(impl.revocationConfiguration())
      .map(value => zio.aws.acmpca.model.RevocationConfiguration.wrap(value))
    override val certificateAuthorityType
        : zio.aws.acmpca.model.CertificateAuthorityType =
      zio.aws.acmpca.model.CertificateAuthorityType
        .wrap(impl.certificateAuthorityType())
    override val idempotencyToken: Option[IdempotencyToken] = scala
      .Option(impl.idempotencyToken())
      .map(value => zio.aws.acmpca.model.primitives.IdempotencyToken(value))
    override val keyStorageSecurityStandard
        : Option[zio.aws.acmpca.model.KeyStorageSecurityStandard] = scala
      .Option(impl.keyStorageSecurityStandard())
      .map(value => zio.aws.acmpca.model.KeyStorageSecurityStandard.wrap(value))
    override val tags: Option[List[zio.aws.acmpca.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest
  ): zio.aws.acmpca.model.CreateCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
