package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{AccountId, Principal, Arn}
import scala.jdk.CollectionConverters._
final case class CreatePermissionRequest(
    certificateAuthorityArn: Arn,
    principal: Principal,
    sourceAccount: Option[AccountId] = None,
    actions: Iterable[zio.aws.acmpca.model.ActionType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest = {
    import CreatePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .principal(Principal.unwrap(principal): java.lang.String)
      .optionallyWith(
        sourceAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .actionsWithStrings(actions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CreatePermissionRequest.ReadOnly =
    zio.aws.acmpca.model.CreatePermissionRequest.wrap(buildAwsValue())
}
object CreatePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CreatePermissionRequest =
      zio.aws.acmpca.model.CreatePermissionRequest(
        certificateAuthorityArn,
        principal,
        sourceAccount.map(value => value),
        actions
      )
    def certificateAuthorityArn: Arn
    def principal: Principal
    def sourceAccount: Option[AccountId]
    def actions: List[zio.aws.acmpca.model.ActionType]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
    def getSourceAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
    def getActions: ZIO[Any, Nothing, List[zio.aws.acmpca.model.ActionType]] =
      ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest
  ) extends zio.aws.acmpca.model.CreatePermissionRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val principal: Principal =
      zio.aws.acmpca.model.primitives.Principal(impl.principal())
    override val sourceAccount: Option[AccountId] = scala
      .Option(impl.sourceAccount())
      .map(value => zio.aws.acmpca.model.primitives.AccountId(value))
    override val actions: List[zio.aws.acmpca.model.ActionType] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.acmpca.model.ActionType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest
  ): zio.aws.acmpca.model.CreatePermissionRequest.ReadOnly = new Wrapper(impl)
}
